/*
 * Decompiled with CFR 0.152.
 */
package com.devintest.api.resources.imdb;

import com.devintest.api.core.ClientOptions;
import com.devintest.api.core.DevintestApiApiException;
import com.devintest.api.core.DevintestApiException;
import com.devintest.api.core.DevintestApiHttpResponse;
import com.devintest.api.core.MediaTypes;
import com.devintest.api.core.ObjectMappers;
import com.devintest.api.core.RequestOptions;
import com.devintest.api.resources.imdb.errors.MovieDoesNotExistError;
import com.devintest.api.resources.imdb.types.CreateMovieRequest;
import com.devintest.api.resources.imdb.types.Movie;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawImdbClient {
    protected final ClientOptions clientOptions;

    public RawImdbClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public DevintestApiHttpResponse<String> createMovie(CreateMovieRequest request) {
        return this.createMovie(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DevintestApiHttpResponse<String> createMovie(CreateMovieRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("movies").addPathSegments("create-movie").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new DevintestApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DevintestApiHttpResponse<String> devintestApiHttpResponse = new DevintestApiHttpResponse<String>((String)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), String.class), response);
                return devintestApiHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new DevintestApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new DevintestApiException("Network error executing HTTP request", e);
        }
    }

    public DevintestApiHttpResponse<Movie> getMovie(String id) {
        return this.getMovie(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DevintestApiHttpResponse<Movie> getMovie(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("movies").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DevintestApiHttpResponse<Movie> devintestApiHttpResponse = new DevintestApiHttpResponse<Movie>((Movie)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Movie.class), response);
                return devintestApiHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 404) throw new DevintestApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new MovieDoesNotExistError((String)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new DevintestApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new DevintestApiException("Network error executing HTTP request", e);
        }
    }
}

