/*
 * Decompiled with CFR 0.152.
 */
package com.devsecops.engine.common;

import com.devsecops.engine.common.contract.Factory;
import com.devsecops.engine.common.contract.Invoker;
import com.devsecops.engine.common.model.BuildParam;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class AbstractSpringMojo
extends AbstractMojo {
    @Parameter(property="env", defaultValue="local")
    private String env;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
            ctx.scan(new String[]{"com.devsecops.engine"});
            ctx.refresh();
            Factory factory = (Factory)ctx.getBean(Class.forName(this.getInvokerClass()));
            this.getLog().info((CharSequence)"Generating config files for env");
            Invoker invoker = (Invoker)factory.build(this.getBuildParameters());
            invoker.execute();
            ctx.close();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    public abstract String getInvokerClass();

    private Map<String, String> getBuildParameters() {
        return Stream.of(new String[][]{{BuildParam.ENV.name(), this.env}}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    }
}

