/*
 * Decompiled with CFR 0.152.
 */
package com.devsecops.engine.genconfig.factory;

import com.devsecops.engine.properties.resolver.Resolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class TokenReplacement {
    private static final String subPattern = "\\$\\{(?<propertyName>[A-Za-z_\\.]+)}";
    private final Pattern pattern = Pattern.compile("\\$\\{(?<propertyName>[A-Za-z_\\.]+)}");
    private Resolver resolver;

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public String replace(String line) {
        Matcher matcher = this.pattern.matcher(line);
        String replaced = line;
        while (matcher.find()) {
            String propertyName = matcher.group("propertyName");
            replaced = matcher.replaceFirst(Matcher.quoteReplacement(this.resolver.resolve(propertyName)));
            matcher = this.pattern.matcher(replaced);
        }
        return replaced;
    }
}

