/*
 * Decompiled with CFR 0.152.
 */
package com.devsecops.engine.genconfig.generator;

import com.devsecops.engine.common.model.Environment;
import com.devsecops.engine.genconfig.factory.TokenReplacement;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class AppConfigFile {
    private final String templatePath;
    private final String outputPath;
    private final TokenReplacement tokenReplacement;
    private static final String TEMPLATE_PATH = "src/main/resources/application-template.yaml";
    private static final String LOWER_ENV_OUTPUT_PATH = "ci/dist/application.yaml";
    private static final String LOCAL_ENV_OUTPUT_PATH = "src/main/resources/application.yaml";
    private static final String LIQUIBASE_TEMPLATE_PATH = "src/main/resources/db/liquibase-template.properties";
    private static final String LIQUIBASE_OUTPUT_PATH = "src/main/resources/db/liquibase.properties";

    public static AppConfigFile getAppConfigInstance(TokenReplacement tokenReplacement, Environment env) {
        return AppConfigFile.builder().tokenReplacement(tokenReplacement).templatePath(TEMPLATE_PATH).outputPath(Environment.LOCAL.equals((Object)env) ? LOCAL_ENV_OUTPUT_PATH : LOWER_ENV_OUTPUT_PATH).build();
    }

    public static AppConfigFile getLiquibaseInstance(TokenReplacement tokenReplacement) {
        return AppConfigFile.builder().tokenReplacement(tokenReplacement).templatePath(LIQUIBASE_TEMPLATE_PATH).outputPath(LIQUIBASE_OUTPUT_PATH).build();
    }

    public Path generate() throws Exception {
        List<String> lines = Files.readAllLines(Paths.get(this.templatePath, new String[0]));
        List replacedLines = lines.stream().map(line -> this.tokenReplacement.replace((String)line)).collect(Collectors.toList());
        return Files.write(Paths.get(this.outputPath, new String[0]), replacedLines, new OpenOption[0]);
    }

    AppConfigFile(String templatePath, String outputPath, TokenReplacement tokenReplacement) {
        this.templatePath = templatePath;
        this.outputPath = outputPath;
        this.tokenReplacement = tokenReplacement;
    }

    public static AppConfigFileBuilder builder() {
        return new AppConfigFileBuilder();
    }

    public static class AppConfigFileBuilder {
        private String templatePath;
        private String outputPath;
        private TokenReplacement tokenReplacement;

        AppConfigFileBuilder() {
        }

        public AppConfigFileBuilder templatePath(String templatePath) {
            this.templatePath = templatePath;
            return this;
        }

        public AppConfigFileBuilder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public AppConfigFileBuilder tokenReplacement(TokenReplacement tokenReplacement) {
            this.tokenReplacement = tokenReplacement;
            return this;
        }

        public AppConfigFile build() {
            return new AppConfigFile(this.templatePath, this.outputPath, this.tokenReplacement);
        }

        public String toString() {
            return "AppConfigFile.AppConfigFileBuilder(templatePath=" + this.templatePath + ", outputPath=" + this.outputPath + ", tokenReplacement=" + this.tokenReplacement + ")";
        }
    }
}

