/*
 * Decompiled with CFR 0.152.
 */
package com.devsecops.engine.properties.resolver;

import com.devsecops.engine.common.Log;
import com.devsecops.engine.properties.resolver.strategy.ResolverStrategy;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

public class Resolver {
    private final ResolverStrategy propertiesResolver;
    private final ResolverStrategy environmentResolver;
    private final Log logger;
    private LoadingCache<String, String> values = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String propertyName) throws Exception {
            return Resolver.this.timeConsumingResolution(propertyName);
        }
    });

    public String resolve(String propertyName) {
        try {
            return (String)this.values.get((Object)propertyName);
        }
        catch (Exception e) {
            this.logger.warn(String.format(">> Property: %s was not resolved, return the key name instead", propertyName));
            return propertyName;
        }
    }

    private String timeConsumingResolution(String propertyName) {
        String propertyValue = propertyName;
        this.logger.info(">> First time resolving property " + propertyName);
        try {
            propertyValue = this.propertiesResolver.resolve(propertyName).orElseGet(() -> this.environmentResolver.resolve(propertyName).get());
        }
        catch (Exception e) {
            this.logger.error(String.format(">> Property: %s was not resolved, return the key name instead", propertyName));
            throw e;
        }
        return propertyValue;
    }

    public Resolver(ResolverStrategy propertiesResolver, ResolverStrategy environmentResolver, Log logger) {
        this.propertiesResolver = propertiesResolver;
        this.environmentResolver = environmentResolver;
        this.logger = logger;
    }
}

