/*
 * Decompiled with CFR 0.152.
 */
package com.devsecops.engine.properties.resolver;

import com.devsecops.engine.common.Log;
import com.devsecops.engine.properties.model.PathList;
import com.devsecops.engine.properties.resolver.Resolver;
import com.devsecops.engine.properties.resolver.strategy.EnvironmentResolverStrategy;
import com.devsecops.engine.properties.resolver.strategy.PropertyFileResolverStrategy;
import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResolverBuilder {
    @Autowired
    private Log logger;
    public PathList pathList;

    public ResolverBuilder with(Consumer<ResolverBuilder> builderConsumer) {
        builderConsumer.accept(this);
        return this;
    }

    public Resolver build() throws IOException {
        PropertyFileResolverStrategy propertiesResolver = new PropertyFileResolverStrategy(this.pathList);
        return new Resolver(propertiesResolver, new EnvironmentResolverStrategy(), this.logger);
    }
}

