/*
 * Decompiled with CFR 0.152.
 */
package com.devsecops.engine.properties.resolver.strategy;

import com.devsecops.engine.properties.model.PathList;
import com.devsecops.engine.properties.resolver.strategy.ResolverStrategy;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class PropertyFileResolverStrategy
implements ResolverStrategy {
    private final Properties properties = new Properties();

    public PropertyFileResolverStrategy(PathList pathList) throws IOException {
        pathList.getPaths().forEach(path -> {
            if (!path.isResource()) {
                try (FileInputStream envStream = new FileInputStream(Paths.get(path.getPath(), new String[0]).toFile());){
                    Properties envProperties = new Properties();
                    envProperties.load(envStream);
                    this.properties.putAll((Map<?, ?>)envProperties);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.propertiesReload();
    }

    private void propertiesReload() {
        Map<String, String> map = this.getAll();
        Set<String> keySet = map.keySet();
        keySet.forEach(key -> {
            String value = (String)map.get(key);
            Set secondKeySet = map.keySet();
            secondKeySet.forEach(secondKey -> {
                String regex = "${" + key + "}";
                String secondValue = (String)map.get(secondKey);
                if (secondValue.contains(regex)) {
                    String replacedValue = secondValue.replace(regex, value);
                    map.replace((String)secondKey, replacedValue);
                }
            });
        });
        this.properties.clear();
        this.properties.putAll(map);
    }

    @Override
    public Optional<String> resolve(String propertyName) {
        return Optional.ofNullable(this.properties.getProperty(propertyName));
    }

    private Map<String, String> getAll() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(k -> k.getKey().toString(), v -> v.getValue().toString()));
    }
}

