/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.core;

import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Invoker;
import java.util.Stack;

public class CommandInvoker
implements Invoker {
    private Stack<Command> pendingCommands;
    private Stack<Command> executedCommands;
    private Log log;

    public CommandInvoker(Stack<Command> pendingQueues, Log log) {
        this.pendingCommands = pendingQueues;
        this.executedCommands = new Stack();
        this.log = log;
    }

    @Override
    public void execute() throws Exception {
        try {
            while (!this.pendingCommands.empty()) {
                Command command = this.pendingCommands.pop();
                this.executedCommands.push(command);
                command.execute();
            }
        }
        catch (Exception e) {
            this.log.error(e);
            this.log.info("Roolback");
            this.rollback();
            throw e;
        }
    }

    private void rollback() {
        try {
            while (!this.executedCommands.empty()) {
                Command command = this.executedCommands.pop();
                command.rollback();
            }
        }
        catch (Exception e) {
            this.log.error(e);
        }
    }
}

