/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.pom.model;

import io.github.devsecops.engine.domain.pom.model.SemanticVersion;
import io.github.devsecops.engine.domain.pom.utils.PomModelUtils;
import io.github.devsecops.engine.domain.pom.utils.SemanticVersionMapper;
import java.util.Optional;
import org.apache.maven.model.Model;

public class Pom {
    private static Pom INSTANCE;
    private final String groupId;
    private final String artifactId;
    private String version;
    private final Model model = PomModelUtils.read();

    public static Pom getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new Pom();
        }
        return INSTANCE;
    }

    private Pom() {
        this.groupId = this.model.getGroupId();
        this.artifactId = this.model.getArtifactId();
        this.version = this.model.getVersion();
    }

    public void removeQualifierFromVersion() {
        this.updateVersion(this.version.replace("-SNAPSHOT", ""));
    }

    public String getJarNam() {
        return String.format("%s-%s.jar", this.artifactId, this.version);
    }

    public Optional<SemanticVersion> getSemanticVersion() {
        return this.version == null ? Optional.empty() : SemanticVersionMapper.toSemanticVersion(this.version);
    }

    public Long snapshotsCount() {
        Long count = this.model.getDependencies().parallelStream().filter(d -> this.isSnapshot(d.getVersion())).count();
        count = count + this.model.getBuild().getPlugins().parallelStream().filter(p -> this.isSnapshot(p.getVersion())).count();
        return count;
    }

    private boolean isSnapshot(String version) {
        return version.contains("SNAPSHOT");
    }

    public void updateVersion(String version) {
        this.version = version;
        Model model = PomModelUtils.read();
        model.setVersion(version);
        PomModelUtils.update(model);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Model getModel() {
        return this.model;
    }
}

