/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.pom.utils;

import io.github.devsecops.engine.domain.pom.model.SemanticVersion;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SemanticVersionMapper {
    private static final String WITH_QUALIFIER_REGEX = "([1-9]\\d*)\\.(\\d+)\\.(\\d+)(?:-([a-zA-z0-9]+))?";
    private static final String WITHOUT_QUALIFIER_REGEX = "([1-9]\\d*)\\.(\\d+)\\.(\\d+)?";
    private static final String DEFAULT_QUALIFIER = "RELEASES";

    public static Optional<SemanticVersion> toSemanticVersion(String version) {
        String qualifier;
        String regex = version.contains("-") ? WITH_QUALIFIER_REGEX : WITHOUT_QUALIFIER_REGEX;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        try {
            qualifier = matcher.group(4);
        }
        catch (Exception e) {
            qualifier = DEFAULT_QUALIFIER;
        }
        return Optional.of(new SemanticVersion(major, minor, patch, qualifier));
    }

    private SemanticVersionMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

