/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.sonar.model;

import io.github.devsecops.engine.domain.sonar.model.MetricReport;
import io.github.devsecops.engine.domain.sonar.model.MetricTargetType;
import io.github.devsecops.engine.domain.sonar.model.MetricType;
import io.github.devsecops.engine.domain.sonar.model.SonarVariables;

public enum Metric {
    RELIABILITY_RATING("reliability_rating", MetricType.RATING, MetricTargetType.AT_MOST, SonarVariables.SONAR_MAX_RELIABILITY_RATING),
    BUGS("bugs", MetricType.INTEGER, MetricTargetType.AT_MOST, SonarVariables.SONAR_MAX_BUGS),
    SECURITY_RATING("security_rating", MetricType.RATING, MetricTargetType.AT_MOST, SonarVariables.SONAR_SECURITY_RATING),
    VULNERABILITIES("vulnerabilities", MetricType.INTEGER, MetricTargetType.AT_MOST, SonarVariables.SONAR_MAX_VULNERABILITIES),
    MAINTAINABILITY_RATING("sqale_rating", MetricType.RATING, MetricTargetType.AT_MOST, SonarVariables.SONAR_MAX_MAINTAINABILITY_RATING),
    CODE_SMELLS("code_smells", MetricType.INTEGER, MetricTargetType.AT_MOST, SonarVariables.SONAR_MAX_CODE_SMELLS),
    COVERAGE("coverage", MetricType.DOUBLE, MetricTargetType.AT_LEAST, SonarVariables.SONAR_MIN_COVERAGE),
    DUPLICATIONS("duplicated_blocks", MetricType.INTEGER, MetricTargetType.AT_MOST, SonarVariables.SONAR_MAX_DUPLICATIONS);

    private String name;
    private MetricType type;
    private MetricTargetType targetType;
    private SonarVariables targetValueProperty;

    public MetricReport evaluate(Integer value, Integer target) {
        switch (this.targetType) {
            case AT_LEAST: {
                return this.shouldBeAtLeast(value, target);
            }
        }
        return this.shouldBeAtMost(value, target);
    }

    private MetricReport shouldBeAtMost(Integer value, Integer target) {
        if (value <= target) {
            return new MetricReport(true, String.format("'%s', the most allowed '%s'", value, target));
        }
        return new MetricReport(false, String.format("'%s' should be less than target '%s'", value, target));
    }

    private MetricReport shouldBeAtLeast(Integer value, Integer target) {
        if (value >= target) {
            return new MetricReport(true, String.format("'%s', the least allowed is '%s'", value, target));
        }
        return new MetricReport(false, String.format("'%s' should be at least as the target '%s'", value, target));
    }

    private Metric(String name, MetricType type, MetricTargetType targetType, SonarVariables targetValueProperty) {
        this.name = name;
        this.type = type;
        this.targetType = targetType;
        this.targetValueProperty = targetValueProperty;
    }

    public String getName() {
        return this.name;
    }

    public MetricType getType() {
        return this.type;
    }

    public MetricTargetType getTargetType() {
        return this.targetType;
    }

    public SonarVariables getTargetValueProperty() {
        return this.targetValueProperty;
    }
}

