/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.core;

import com.google.common.collect.Lists;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.core.contract.Instruction;
import java.util.List;

public class InstructionInvoker
implements Command {
    private final List<Instruction> instructions;
    private final Executor executor;

    private InstructionInvoker(Executor executor) {
        this.executor = executor;
        this.instructions = Lists.newArrayList();
    }

    public InstructionInvoker append(Instruction instruction) {
        this.instructions.add(instruction);
        return this;
    }

    public static InstructionInvoker init(Executor executor) {
        return new InstructionInvoker(executor);
    }

    @Override
    public void execute() throws Exception {
        for (Instruction instruction : this.instructions) {
            this.executor.execute(instruction.getCmd());
        }
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback defined for multiple instructions");
    }
}

