/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.artifact.commands;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.domain.artifact.instructions.JavaPathInstruction;
import io.github.devsecops.engine.domain.artifact.instructions.MavenCleanInstruction;
import io.github.devsecops.engine.domain.artifact.instructions.MavenDeployArtifactInstruction;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import io.github.devsecops.engine.domain.pom.model.Pom;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployArtifactCommand
implements Command {
    private static final String MAVEN_SETTINGS = "MAVEN_SETTINGS";
    private static final String JAVA_HOME = "JAVA_HOME";
    @Autowired
    private Executor executor;
    private ArtifactRepositoryType repositoryType;
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        if (ArtifactRepositoryType.RELEASE.equals((Object)this.repositoryType)) {
            Pom.getINSTANCE().removeQualifierFromVersion();
        }
        MavenCleanInstruction clean = MavenCleanInstruction.builder().settings(this.resolver.resolve(MAVEN_SETTINGS)).build();
        MavenDeployArtifactInstruction deploy = MavenDeployArtifactInstruction.builder().settings(this.resolver.resolve(MAVEN_SETTINGS)).build();
        JavaPathInstruction java = JavaPathInstruction.builder().javaHome(this.resolver.resolve(JAVA_HOME)).build();
        InstructionInvoker.init(this.executor).append(java).append(clean).append(deploy).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }

    public void setRepositoryType(ArtifactRepositoryType repositoryType) {
        this.repositoryType = repositoryType;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }
}

