/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.resolver.path;

import com.google.common.collect.ImmutableMap;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.resolver.model.PathCompose;
import io.github.devsecops.engine.domain.resolver.model.PathList;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PathListConfig {
    @Qualifier(value="PathList")
    @Bean
    public Map<String, PathList> getMap() {
        return ImmutableMap.of((Object)Environment.LOCAL.name(), (Object)this.getFromVar("local"), (Object)Environment.DEV.name(), (Object)this.getFromVar("dev"), (Object)Environment.UAT.name(), (Object)this.getFromVar("uat"));
    }

    private PathList getFromVar(String environment) {
        return new PathList(Arrays.asList(this.newResourcePropertyFile("infra"), this.newResourcePropertyFile("vault"), this.newResourcePropertyFile("git"), this.newResourcePropertyFile("sonar"), this.newPropertyFile("default"), this.newPropertyFile(environment)));
    }

    private PathCompose newResourcePropertyFile(String propertyFileName) {
        return PathCompose.builder().path(String.format("/vars/%s.properties", propertyFileName)).resource(true).build();
    }

    private PathCompose newPropertyFile(String propertyFileName) {
        return PathCompose.builder().path(String.format("./ci/vars/%s.properties", propertyFileName)).build();
    }
}

