/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.resolver.strategy.impl;

import io.github.devsecops.engine.domain.resolver.model.PathList;
import io.github.devsecops.engine.domain.resolver.strategy.ResolverStrategy;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class PropertyFileResolverStrategy
implements ResolverStrategy {
    private final Properties properties = new Properties();

    public PropertyFileResolverStrategy(PathList pathList) throws IOException {
        pathList.getPaths().forEach(path -> {
            if (path.isResource()) {
                try (InputStream resource = FileUtils.class.getResourceAsStream(path.getPath());){
                    this.properties.load(resource);
                }
                catch (Exception e) {
                    System.out.println("Couldn't load file from resource " + path.getPath());
                }
            } else {
                try (FileInputStream envStream = new FileInputStream(Paths.get(path.getPath(), new String[0]).toFile());){
                    Properties envProperties = new Properties();
                    envProperties.load(envStream);
                    this.properties.putAll((Map<?, ?>)envProperties);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.propertiesReload();
    }

    private void propertiesReload() {
        Map<String, String> map = this.getAll();
        Set<String> keySet = map.keySet();
        keySet.forEach(key -> {
            String value = (String)map.get(key);
            Set secondKeySet = map.keySet();
            secondKeySet.forEach(secondKey -> {
                String regex = "${" + key + "}";
                String secondValue = (String)map.get(secondKey);
                if (secondValue.contains(regex)) {
                    String replacedValue = secondValue.replace(regex, value);
                    map.replace((String)secondKey, replacedValue);
                }
            });
        });
        this.properties.clear();
        this.properties.putAll(map);
    }

    @Override
    public Optional<String> resolve(String propertyName) {
        return Optional.ofNullable(this.properties.getProperty(propertyName));
    }

    private Map<String, String> getAll() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(k -> k.getKey().toString(), v -> v.getValue().toString()));
    }
}

