/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.sonar.commands;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.sonar.instructions.SonarAnalysisInstruction;
import io.github.devsecops.engine.domain.sonar.model.SonarVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SonarAnalysisCommand
implements Command {
    @Autowired
    private Executor executor;
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        SonarAnalysisInstruction sonarAnalysis = SonarAnalysisInstruction.builder().sonarUrl(this.resolver.resolve(SonarVariables.SONAR_URL.getName())).loginKey(this.resolver.resolve(SonarVariables.SONAR_LOGIN_KEY.getName())).projectKey(this.resolver.resolve(SonarVariables.SONAR_COMPONENT.getName())).build();
        InstructionInvoker.init(this.executor).append(sonarAnalysis).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for sonar analysis commands");
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }
}

