/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.mojos.artifact;

import io.github.devsecops.engine.core.CommandInvoker;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.core.model.BuildParam;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.artifact.commands.DeployArtifactCommand;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import io.github.devsecops.engine.domain.git.commands.GitCommitAndPushPomCommand;
import io.github.devsecops.engine.domain.pom.commands.PomIncreaseVersionCommand;
import io.github.devsecops.engine.domain.resolver.path.PathResolverBuilder;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeployArtifactFactory
implements Factory<Invoker> {
    private static final List<Environment> RELEASES_ENV = Arrays.asList(Environment.UAT);
    @Autowired
    private Log logger;
    @Autowired
    private PathResolverBuilder pathResolverFactory;
    @Autowired
    private DeployArtifactCommand deployArtifactCommand;
    @Autowired
    private PomIncreaseVersionCommand pomIncreaseVersionCommand;
    @Autowired
    private GitCommitAndPushPomCommand gitCommitAndPushPomCommand;

    @Override
    public Invoker build(Map<String, String> parameters) throws Exception {
        Object resolver = this.pathResolverFactory.build((Map)parameters);
        ArtifactRepositoryType repositoryType = this.getRepositoryType(parameters);
        this.deployArtifactCommand.setRepositoryType(repositoryType);
        this.deployArtifactCommand.setResolver((Resolver)resolver);
        Stack<Command> commands = new Stack<Command>();
        if (Boolean.TRUE.equals(this.isToIncreasePom(parameters))) {
            this.gitCommitAndPushPomCommand.setResolver((Resolver)resolver);
            commands.push(this.gitCommitAndPushPomCommand);
            commands.push(this.pomIncreaseVersionCommand);
        }
        commands.push(this.deployArtifactCommand);
        return new CommandInvoker(commands, this.logger);
    }

    private Boolean isToIncreasePom(Map<String, String> parameters) {
        String increaseVersion = parameters.get(BuildParam.INCREASE_VERSION.name());
        return increaseVersion != null ? Boolean.valueOf(increaseVersion) : Boolean.FALSE;
    }

    private ArtifactRepositoryType getRepositoryType(Map<String, String> parameters) {
        Environment env = Environment.valueOf(parameters.get(BuildParam.ENV.name()).toUpperCase());
        return RELEASES_ENV.contains((Object)env) ? ArtifactRepositoryType.RELEASE : ArtifactRepositoryType.SNAPSHOT;
    }
}

