/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.docker.commands;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import io.github.devsecops.engine.domain.docker.instructions.DockerLoginInstruction;
import io.github.devsecops.engine.domain.docker.model.DockerVariables;
import io.github.devsecops.engine.domain.pom.model.Pom;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildImageCommand
implements Command {
    @Autowired
    private Executor executor;
    private ArtifactRepositoryType repositoryType;
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        if (ArtifactRepositoryType.RELEASE.equals((Object)this.repositoryType)) {
            Pom.getINSTANCE().removeQualifierFromVersion();
        }
        DockerLoginInstruction login = DockerLoginInstruction.builder().password(this.resolver.resolve(DockerVariables.DOCKER_HUB_PASSWORD.getName())).build();
        InstructionInvoker.init(this.executor).append(login).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }

    public void setRepositoryType(ArtifactRepositoryType repositoryType) {
        this.repositoryType = repositoryType;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }
}

