/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.docker.instructions;

import io.github.devsecops.engine.core.contract.Instruction;

public class DockerLoginInstruction
implements Instruction {
    private static final String CMD = "echo \"%s\" | docker login --username devsecops2021 --password-stdin";
    private final String password;

    @Override
    public String getCmd() {
        return String.format(CMD, this.password);
    }

    public static DockerLoginInstructionBuilder builder() {
        return new DockerLoginInstructionBuilder();
    }

    public DockerLoginInstruction(String password) {
        this.password = password;
    }

    public static class DockerLoginInstructionBuilder {
        private String password;

        DockerLoginInstructionBuilder() {
        }

        public DockerLoginInstructionBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DockerLoginInstruction build() {
            return new DockerLoginInstruction(this.password);
        }

        public String toString() {
            return "DockerLoginInstruction.DockerLoginInstructionBuilder(password=" + this.password + ")";
        }
    }
}

