/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.resolver.path;

import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.model.BuildParam;
import io.github.devsecops.engine.domain.resolver.model.PathList;
import io.github.devsecops.engine.domain.resolver.model.VaultVariables;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.resolver.strategy.impl.EnvironmentResolverStrategy;
import io.github.devsecops.engine.domain.resolver.strategy.impl.PropertyFileResolverStrategy;
import io.github.devsecops.engine.domain.resolver.strategy.impl.VaultResolverStrategy;
import io.github.devsecops.engine.domain.resolver.utils.VaultBuilder;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PathResolverBuilder
implements Factory<Resolver> {
    @Autowired
    private Log logger;
    @Autowired
    @Qualifier(value="PathList")
    private Map<String, PathList> pathListMap;

    private PathList getPathList(Map<String, String> parameters) {
        return this.pathListMap.get(parameters.get(BuildParam.ENV.name()).toUpperCase());
    }

    @Override
    public Resolver build(Map<String, String> parameters) throws Exception {
        PathList pathList = this.getPathList(parameters);
        PropertyFileResolverStrategy propertiesResolver = new PropertyFileResolverStrategy(pathList);
        EnvironmentResolverStrategy environmentResolver = new EnvironmentResolverStrategy();
        VaultResolverStrategy vaultStrategyResolver = new VaultResolverStrategy(VaultBuilder.newVault(propertiesResolver.resolve(VaultVariables.VAULT_URL.getName()).orElse(null), environmentResolver.resolve(VaultVariables.VAULT_ROLE_ID.getName()).orElse(null), environmentResolver.resolve(VaultVariables.VAULT_SECRET_ID.getName()).orElse(null)), propertiesResolver.resolve(VaultVariables.VAULT_APP_PATH.getName()).orElse(null));
        return new Resolver(propertiesResolver, environmentResolver, vaultStrategyResolver, this.logger);
    }
}

