/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.resolver.utils;

import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class TokenReplacement {
    private static final String KEY = "propertyName";
    private static final String SUB_PATTERN = "\\$\\{(?<propertyName>[A-Za-z_\\.]+)}";
    private final Pattern pattern = Pattern.compile("\\$\\{(?<propertyName>[A-Za-z_\\.]+)}");
    private Resolver resolver;

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public String replace(String line) {
        Matcher matcher = this.pattern.matcher(line);
        while (matcher.find()) {
            String propertyName = matcher.group(KEY);
            line = matcher.replaceFirst(Matcher.quoteReplacement(this.resolver.resolve(propertyName)));
            matcher = this.pattern.matcher(line);
        }
        return line;
    }
}

