/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.sonar.commands;

import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.exceptions.AbortPipelineException;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.sonar.api.SonarMeasuresApi;
import io.github.devsecops.engine.domain.sonar.model.Metric;
import io.github.devsecops.engine.domain.sonar.model.MetricReport;
import io.github.devsecops.engine.domain.sonar.model.SonarVariables;
import io.github.devsecops.engine.domain.sonar.utils.SonarMeasureValidator;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.wsclient.SonarClient;
import org.springframework.stereotype.Component;

@Component
public class SonarCheckQualityCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(SonarCheckQualityCommand.class);
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        String component;
        SonarClient client = SonarClient.builder().url(this.resolver.resolve(SonarVariables.SONAR_URL.getName())).login(this.resolver.resolve(SonarVariables.SONAR_LOGIN.getName())).password(this.resolver.resolve(SonarVariables.SONAR_PASSWORD.getName())).build();
        SonarMeasuresApi sonarMeasuresApi = new SonarMeasuresApi(client);
        Map<Metric, Integer> measures = sonarMeasuresApi.calculate(component = this.resolver.resolve(SonarVariables.SONAR_COMPONENT.getName()));
        boolean isValid = this.validate(measures);
        if (!isValid) {
            throw new AbortPipelineException("Quality Check failed");
        }
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for sonar check quality");
    }

    private boolean validate(Map<Metric, Integer> measures) {
        Map<Metric, Integer> targets = this.buildMetricTarget();
        SonarMeasureValidator validator = new SonarMeasureValidator(targets);
        Map<Metric, MetricReport> validations = validator.perform(measures);
        validations.entrySet().forEach(entry -> log.info(String.format("[%s] %s", ((Metric)((Object)((Object)entry.getKey()))).getName(), entry.getValue())));
        return validations.entrySet().stream().map(Map.Entry::getValue).allMatch(MetricReport::isSuccess);
    }

    private Map<Metric, Integer> buildMetricTarget() {
        return Arrays.asList(Metric.values()).parallelStream().collect(Collectors.toMap(Function.identity(), this::getTarget));
    }

    private Integer getTarget(Metric metric) {
        SonarVariables property = metric.getTargetValueProperty();
        String value = this.resolver.resolve(property.getName());
        return Integer.valueOf(value.trim());
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }
}

