/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.domain.sonar.instructions;

import io.github.devsecops.engine.core.contract.Instruction;

public class SonarAnalysisInstruction
implements Instruction {
    private static final String COMMAND = "mvn clean install sonar:sonar -Dsonar.host.url=%s -Dsonar.login=%s -Dsonar.projectKey=%s";
    private String sonarUrl;
    private String loginKey;
    private String projectKey;

    @Override
    public String getCmd() {
        return String.format(COMMAND, this.sonarUrl, this.loginKey, this.projectKey);
    }

    public static SonarAnalysisInstructionBuilder builder() {
        return new SonarAnalysisInstructionBuilder();
    }

    public SonarAnalysisInstruction(String sonarUrl, String loginKey, String projectKey) {
        this.sonarUrl = sonarUrl;
        this.loginKey = loginKey;
        this.projectKey = projectKey;
    }

    public static class SonarAnalysisInstructionBuilder {
        private String sonarUrl;
        private String loginKey;
        private String projectKey;

        SonarAnalysisInstructionBuilder() {
        }

        public SonarAnalysisInstructionBuilder sonarUrl(String sonarUrl) {
            this.sonarUrl = sonarUrl;
            return this;
        }

        public SonarAnalysisInstructionBuilder loginKey(String loginKey) {
            this.loginKey = loginKey;
            return this;
        }

        public SonarAnalysisInstructionBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public SonarAnalysisInstruction build() {
            return new SonarAnalysisInstruction(this.sonarUrl, this.loginKey, this.projectKey);
        }

        public String toString() {
            return "SonarAnalysisInstruction.SonarAnalysisInstructionBuilder(sonarUrl=" + this.sonarUrl + ", loginKey=" + this.loginKey + ", projectKey=" + this.projectKey + ")";
        }
    }
}

