/*
 * Decompiled with CFR 0.152.
 */
package io.github.devsecops.engine.mojos.image;

import io.github.devsecops.engine.core.CommandInvoker;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.core.model.BuildParam;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import io.github.devsecops.engine.domain.docker.commands.BuildImageCommand;
import io.github.devsecops.engine.domain.resolver.path.PathResolverBuilder;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BuildImageFactory
implements Factory<Invoker> {
    private static final List<Environment> RELEASES_ENV = Arrays.asList(Environment.UAT);
    @Autowired
    private Log logger;
    @Autowired
    private PathResolverBuilder pathResolverFactory;
    @Autowired
    private BuildImageCommand buildImageCommand;

    @Override
    public Invoker build(Map<String, String> parameters) throws Exception {
        Object resolver = this.pathResolverFactory.build((Map)parameters);
        ArtifactRepositoryType repositoryType = this.getRepositoryType(parameters);
        this.buildImageCommand.setRepositoryType(repositoryType);
        this.buildImageCommand.setResolver((Resolver)resolver);
        Stack<Command> commands = new Stack<Command>();
        commands.push(this.buildImageCommand);
        return new CommandInvoker(commands, this.logger);
    }

    private ArtifactRepositoryType getRepositoryType(Map<String, String> parameters) {
        Environment env = Environment.valueOf(parameters.get(BuildParam.ENV.name()).toUpperCase());
        return RELEASES_ENV.contains((Object)env) ? ArtifactRepositoryType.RELEASE : ArtifactRepositoryType.SNAPSHOT;
    }
}

