/*
 * Decompiled with CFR 0.152.
 */
package io.github.javacodesign.plugin;

import io.github.javacodesign.JLinker;
import io.github.javacodesign.JPackager;
import io.github.javacodesign.Notarizer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.lingala.zip4j.ZipFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="package-and-codesign", defaultPhase=LifecyclePhase.PACKAGE)
public class JpackageMojo
extends AbstractMojo {
    private static final String jlinkOut = "runtime";
    private static final String jpackageOut = "appdir";
    private static final String modsDir = "mods";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDirectory;
    @Parameter(required=true)
    String jreModuleNames;
    @Parameter(required=true)
    String jreModules;
    @Parameter
    String applicationModulesPath;
    @Parameter(required=true)
    String moduleName;
    @Parameter(required=true)
    String appVersion;
    @Parameter(required=true)
    String packageIdentifier;
    @Parameter(required=true)
    String moduleStarter;
    @Parameter
    String developerId;
    @Parameter
    String apiKey;
    @Parameter
    String apiIssuer;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block10: {
            this.getLog().debug((CharSequence)("project build directory: " + this.buildDirectory));
            this.getLog().debug((CharSequence)("project artifact file: " + this.project.getArtifact().getFile().toString()));
            this.getLog().debug((CharSequence)("project artifacts: " + this.project.getArtifacts().toString()));
            List javaModules = Stream.of(this.jreModuleNames.split(",")).filter(Objects::nonNull).map(String::trim).collect(Collectors.toList());
            this.getLog().info((CharSequence)("Config: jreModules: " + this.jreModules));
            this.getLog().info((CharSequence)("Config: applicationModulesPath: " + this.applicationModulesPath));
            try {
                Path to = Paths.get(this.applicationModulesPath, this.project.getArtifact().getFile().getName());
                Path from = this.project.getArtifact().getFile().toPath();
                this.getLog().info((CharSequence)("Copying from " + from + " to " + to));
                Files.copy(from, to, new CopyOption[0]);
                if (!new JLinker(javaModules, this.jreModules, this.buildDirectory + "/runtime").apply()) break block10;
                this.getLog().info((CharSequence)"Jlink successful");
                JPackager jPackager = JPackager.builder().module(this.moduleStarter).name(this.moduleName).appVersion(this.appVersion).dest(this.relativeToBuildDirectory(jpackageOut)).macPackageIdentifier(this.packageIdentifier).runtimeImage(this.relativeToBuildDirectory(jlinkOut)).signingKeyUserName(this.developerId).modulePath(Collections.singletonList(this.applicationModulesPath)).build();
                if (!jPackager.apply()) break block10;
                this.getLog().info((CharSequence)"JPackage successful");
                Path zipFilePath = Path.of(this.relativeToBuildDirectory(jpackageOut) + ".zip", new String[0]);
                try (ZipFile zipFile = new ZipFile(zipFilePath.toString());){
                    zipFile.addFolder(Path.of(this.relativeToBuildDirectory(jpackageOut), new String[0]).toFile());
                }
                this.getLog().info((CharSequence)("Zipped to " + zipFilePath));
                if (!(this.packageIdentifier == null || this.packageIdentifier.isEmpty() || this.apiKey == null || this.apiKey.isEmpty() || this.apiIssuer == null || this.apiIssuer.isEmpty())) {
                    this.getLog().info((CharSequence)"Running notarization");
                    Notarizer notarizer = new Notarizer(this.packageIdentifier, this.apiKey, this.apiIssuer, zipFilePath);
                    if (notarizer.notarize()) {
                        this.getLog().info((CharSequence)"Notarization successful");
                    } else {
                        this.getLog().info((CharSequence)"Notarization did not succeed in time.");
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.toString());
            }
        }
    }

    private String relativeToBuildDirectory(String string) {
        return this.buildDirectory + "/" + string.trim();
    }
}

