/*
 * Decompiled with CFR 0.152.
 */
package io.github.javacodesign.plugin;

import io.github.javacodesign.DebDetector;
import io.github.javacodesign.DmgCodeSigner;
import io.github.javacodesign.JLinker;
import io.github.javacodesign.JPackager;
import io.github.javacodesign.LinuxAppImageJPackager;
import io.github.javacodesign.LinuxDebJPackager;
import io.github.javacodesign.LinuxRpmJPackager;
import io.github.javacodesign.MacJPackager;
import io.github.javacodesign.NotarizationStapler;
import io.github.javacodesign.Notarizer;
import io.github.javacodesign.RpmDetector;
import io.github.javacodesign.WindowsJPackager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="package-and-codesign", defaultPhase=LifecyclePhase.PACKAGE)
public class JpackageMojo
extends AbstractMojo {
    private static final String jlinkOut = "runtime";
    private static final String jpackageOut = "appdir";
    private static final String modsDir = "mods";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDirectory;
    @Parameter(required=true)
    String jreModuleNames;
    @Parameter(required=true)
    String jreModules;
    @Parameter(required=true)
    String moduleName;
    @Parameter(required=true)
    String appVersion;
    @Parameter(required=true)
    String moduleStarter;
    @Parameter
    String packageIdentifier;
    @Parameter
    String icon;
    @Parameter
    String resourceDir;
    @Parameter
    String applicationModulesPath;
    @Parameter
    String macDeveloperId;
    @Parameter
    String macKeychainProfile;
    @Parameter
    String winUpgradeUuid;
    @Parameter
    String macPackageName;
    @Parameter
    String linuxDebMaintainer;
    @Parameter
    String linuxMenuGroup;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("project build directory: " + this.buildDirectory));
        this.getLog().debug((CharSequence)("project artifact file: " + this.project.getArtifact().getFile().toString()));
        this.getLog().debug((CharSequence)("project artifacts: " + this.project.getArtifacts().toString()));
        List javaModules = Stream.of(this.jreModuleNames.split(",")).filter(Objects::nonNull).map(String::trim).collect(Collectors.toList());
        this.getLog().info((CharSequence)("Config: jreModules: " + this.jreModules));
        this.getLog().info((CharSequence)("Config: applicationModulesPath: " + this.applicationModulesPath));
        try {
            Path to = Paths.get(this.applicationModulesPath, this.project.getArtifact().getFile().getName());
            Path from = this.project.getArtifact().getFile().toPath();
            this.getLog().info((CharSequence)("Copying from " + from + " to " + to));
            Files.copy(from, to, new CopyOption[0]);
            this.getLog().info((CharSequence)"Running Jlink");
            if (!new JLinker(javaModules, this.jreModules, this.buildDirectory + "/runtime").apply()) {
                throw new MojoFailureException("Jlink failed.");
            }
            this.getLog().info((CharSequence)"Jlink successful");
            this.getLog().info((CharSequence)"Running JPackage");
            if (SystemUtils.IS_OS_WINDOWS) {
                this.runWindows();
            }
            if (SystemUtils.IS_OS_LINUX) {
                this.runLinux();
            }
            if (SystemUtils.IS_OS_MAC) {
                this.runMac();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.toString());
        }
    }

    void configure(JPackager jPackager) {
        jPackager.setModule(this.moduleStarter).setName(this.moduleName).setAppVersion(this.appVersion).setIcon(this.icon).setDest(this.relativeToBuildDirectory(jpackageOut)).setRuntimeImage(this.relativeToBuildDirectory(jlinkOut)).setModulePath(Collections.singletonList(this.applicationModulesPath)).setResourceDir(this.resourceDir);
    }

    private void runWindows() throws IOException, MojoFailureException {
        WindowsJPackager jPackager = new WindowsJPackager();
        this.configure((JPackager)jPackager);
        jPackager.setWinUpgradeUuid(this.winUpgradeUuid);
        if (!jPackager.apply()) {
            throw new MojoFailureException("JPackage failed.");
        }
        this.getLog().info((CharSequence)"JPackage successful");
    }

    private void runLinux() throws MojoFailureException, IOException {
        this.runAppImage();
        Path path = Paths.get(this.relativeToBuildDirectory(jpackageOut), this.moduleName);
        try (ZipFile zipFile = new ZipFile(path + "-" + this.appVersion + ".zip");){
            zipFile.addFolder(path.toFile());
        }
        this.getLog().info((CharSequence)("Zipped app image to " + path + "-" + this.appVersion + ".zip"));
        if (new DebDetector().apply()) {
            this.runDmg();
        } else if (new RpmDetector().apply()) {
            this.runRpm();
        } else {
            throw new MojoFailureException("Could neither find dmg nor rpm");
        }
    }

    private void runAppImage() throws MojoFailureException, IOException {
        LinuxAppImageJPackager jPackager = new LinuxAppImageJPackager();
        this.configure((JPackager)jPackager);
        if (!jPackager.apply()) {
            throw new MojoFailureException("JPackage (appImage) failed.");
        }
        this.getLog().info((CharSequence)"JPackage (appImage) successful");
    }

    private void runRpm() throws MojoFailureException, IOException {
        LinuxRpmJPackager jPackager = new LinuxRpmJPackager();
        this.configure((JPackager)jPackager);
        jPackager.setLinuxMenuGroup(this.linuxMenuGroup);
        if (!jPackager.apply()) {
            throw new MojoFailureException("JPackage (rpm) failed.");
        }
        this.getLog().info((CharSequence)"JPackage (rpm) successful");
    }

    private void runDmg() throws MojoFailureException, IOException {
        LinuxDebJPackager jPackager = new LinuxDebJPackager();
        this.configure((JPackager)jPackager);
        jPackager.setLinuxDebMaintainer(this.linuxDebMaintainer).setLinuxMenuGroup(this.linuxMenuGroup);
        if (!jPackager.apply()) {
            throw new MojoFailureException("JPackage (deb) failed.");
        }
        this.getLog().info((CharSequence)"JPackage (deb) successful");
    }

    private void runMac() throws MojoFailureException, IOException {
        MacJPackager jPackager = new MacJPackager();
        this.configure((JPackager)jPackager);
        jPackager.setMacPackageIdentifier(this.packageIdentifier).setMacSigningKeyUserName(this.macDeveloperId).setMacSigningKeyUserName(this.macDeveloperId).setMacPackageName(this.macPackageName);
        if (!jPackager.apply()) {
            throw new MojoFailureException("JPackage failed.");
        }
        this.getLog().info((CharSequence)"JPackage successful");
        Path dmgPath = Paths.get(jPackager.getDest(), jPackager.getName() + "-" + jPackager.getAppVersion() + ".dmg");
        this.getLog().info((CharSequence)"Code signing dmg");
        if (!new DmgCodeSigner().setDeveloperId(this.macDeveloperId).setDmgPath(dmgPath.toString()).apply()) {
            throw new MojoFailureException("Code signing dmg failed");
        }
        this.getLog().info((CharSequence)"Code signing dmg successful");
        this.getLog().info((CharSequence)"Running notarization (this will take a few minutes)");
        Notarizer notarizer = new Notarizer(Paths.get(jPackager.getDest(), jPackager.getName() + "-" + jPackager.getAppVersion() + ".dmg"), this.macKeychainProfile);
        if (!notarizer.notarize()) {
            throw new MojoFailureException("Notarization failed.");
        }
        this.getLog().info((CharSequence)"Notarization successful");
        this.getLog().info((CharSequence)"Running notarization stapler");
        if (!new NotarizationStapler().setDmgPath(dmgPath.toString()).apply()) {
            throw new MojoFailureException("Notarization stapler failed.");
        }
        this.getLog().info((CharSequence)"Notarization stapler successful");
    }

    private String relativeToBuildDirectory(String string) {
        return Paths.get(this.buildDirectory.toString(), string.trim()).toString();
    }
}

