/*
 * Decompiled with CFR 0.152.
 */
package org.openea.eap.module.system.api.oauth2;

import javax.annotation.Resource;
import org.openea.eap.framework.common.pojo.CommonResult;
import org.openea.eap.framework.common.util.object.BeanUtils;
import org.openea.eap.module.system.api.oauth2.OAuth2TokenApi;
import org.openea.eap.module.system.api.oauth2.dto.OAuth2AccessTokenCheckRespDTO;
import org.openea.eap.module.system.api.oauth2.dto.OAuth2AccessTokenCreateReqDTO;
import org.openea.eap.module.system.api.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.openea.eap.module.system.dal.dataobject.oauth2.OAuth2AccessTokenDO;
import org.openea.eap.module.system.service.oauth2.OAuth2TokenService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class OAuth2TokenApiImpl
implements OAuth2TokenApi {
    @Resource
    private OAuth2TokenService oauth2TokenService;

    public CommonResult<OAuth2AccessTokenRespDTO> createAccessToken(OAuth2AccessTokenCreateReqDTO reqDTO) {
        OAuth2AccessTokenDO accessTokenDO = this.oauth2TokenService.createAccessToken(reqDTO.getUserId(), reqDTO.getUserType(), reqDTO.getClientId(), reqDTO.getScopes());
        return CommonResult.success((Object)((OAuth2AccessTokenRespDTO)BeanUtils.toBean((Object)accessTokenDO, OAuth2AccessTokenRespDTO.class)));
    }

    public CommonResult<OAuth2AccessTokenCheckRespDTO> checkAccessToken(String accessToken) {
        OAuth2AccessTokenDO accessTokenDO = this.oauth2TokenService.checkAccessToken(accessToken);
        return CommonResult.success((Object)((OAuth2AccessTokenCheckRespDTO)BeanUtils.toBean((Object)accessTokenDO, OAuth2AccessTokenCheckRespDTO.class)));
    }

    public CommonResult<OAuth2AccessTokenRespDTO> removeAccessToken(String accessToken) {
        OAuth2AccessTokenDO accessTokenDO = this.oauth2TokenService.removeAccessToken(accessToken);
        return CommonResult.success((Object)((OAuth2AccessTokenRespDTO)BeanUtils.toBean((Object)accessTokenDO, OAuth2AccessTokenRespDTO.class)));
    }

    public CommonResult<OAuth2AccessTokenRespDTO> refreshAccessToken(String refreshToken, String clientId) {
        OAuth2AccessTokenDO accessTokenDO = this.oauth2TokenService.refreshAccessToken(refreshToken, clientId);
        return CommonResult.success((Object)((OAuth2AccessTokenRespDTO)BeanUtils.toBean((Object)accessTokenDO, OAuth2AccessTokenRespDTO.class)));
    }
}

