/*
 * Decompiled with CFR 0.152.
 */
package org.openea.eap.module.system.api.social;

import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.subscribemsg.TemplateInfo;
import org.openea.eap.framework.common.pojo.CommonResult;
import org.openea.eap.framework.common.util.collection.CollectionUtils;
import org.openea.eap.framework.common.util.object.BeanUtils;
import org.openea.eap.module.system.api.social.SocialClientApi;
import org.openea.eap.module.system.api.social.dto.SocialUserRespDTO;
import org.openea.eap.module.system.api.social.dto.SocialWxJsapiSignatureRespDTO;
import org.openea.eap.module.system.api.social.dto.SocialWxPhoneNumberInfoRespDTO;
import org.openea.eap.module.system.api.social.dto.SocialWxQrcodeReqDTO;
import org.openea.eap.module.system.api.social.dto.SocialWxaSubscribeMessageSendReqDTO;
import org.openea.eap.module.system.api.social.dto.SocialWxaSubscribeTemplateRespDTO;
import org.openea.eap.module.system.enums.social.SocialTypeEnum;
import org.openea.eap.module.system.service.social.SocialClientService;
import org.openea.eap.module.system.service.social.SocialUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class SocialClientApiImpl
implements SocialClientApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocialClientApiImpl.class);
    @Resource
    private SocialClientService socialClientService;
    @Resource
    private SocialUserService socialUserService;

    public CommonResult<String> getAuthorizeUrl(Integer socialType, Integer userType, String redirectUri) {
        return CommonResult.success((Object)this.socialClientService.getAuthorizeUrl(socialType, userType, redirectUri));
    }

    public CommonResult<SocialWxJsapiSignatureRespDTO> createWxMpJsapiSignature(Integer userType, String url) {
        WxJsapiSignature signature = this.socialClientService.createWxMpJsapiSignature(userType, url);
        return CommonResult.success((Object)((SocialWxJsapiSignatureRespDTO)BeanUtils.toBean((Object)signature, SocialWxJsapiSignatureRespDTO.class)));
    }

    public CommonResult<SocialWxPhoneNumberInfoRespDTO> getWxMaPhoneNumberInfo(Integer userType, String phoneCode) {
        WxMaPhoneNumberInfo info = this.socialClientService.getWxMaPhoneNumberInfo(userType, phoneCode);
        return CommonResult.success((Object)((SocialWxPhoneNumberInfoRespDTO)BeanUtils.toBean((Object)info, SocialWxPhoneNumberInfoRespDTO.class)));
    }

    public CommonResult<byte[]> getWxaQrcode(SocialWxQrcodeReqDTO reqVO) {
        return CommonResult.success((Object)this.socialClientService.getWxaQrcode(reqVO));
    }

    public CommonResult<List<SocialWxaSubscribeTemplateRespDTO>> getWxaSubscribeTemplateList(Integer userType) {
        List list = this.socialClientService.getSubscribeTemplateList(userType);
        return CommonResult.success((Object)CollectionUtils.convertList((Collection)list, item -> ((SocialWxaSubscribeTemplateRespDTO)BeanUtils.toBean((Object)item, SocialWxaSubscribeTemplateRespDTO.class)).setId(item.getPriTmplId())));
    }

    public CommonResult<Boolean> sendWxaSubscribeMessage(SocialWxaSubscribeMessageSendReqDTO reqDTO) {
        List templateList = this.socialClientService.getSubscribeTemplateList(reqDTO.getUserType());
        if (CollUtil.isEmpty((Collection)templateList)) {
            log.warn("[sendSubscribeMessage][reqDTO({}) \u53d1\u9001\u8ba2\u9605\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u627e\u5230\u8ba2\u9605\u6a21\u677f]", (Object)reqDTO);
            return CommonResult.success((Object)false);
        }
        TemplateInfo template = (TemplateInfo)CollUtil.findOne((Iterable)templateList, item -> ObjUtil.equal((Object)item.getTitle(), (Object)reqDTO.getTemplateTitle()));
        if (template == null) {
            log.warn("[sendWxaSubscribeMessage][reqDTO({}) \u53d1\u9001\u8ba2\u9605\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u627e\u5230\u8ba2\u9605\u6a21\u677f]", (Object)reqDTO);
            return CommonResult.success((Object)false);
        }
        SocialUserRespDTO socialUser = this.socialUserService.getSocialUserByUserId(reqDTO.getUserType(), reqDTO.getUserId(), SocialTypeEnum.WECHAT_MINI_APP.getType());
        if (StrUtil.isBlankIfStr((Object)socialUser.getOpenid())) {
            log.warn("[sendWxaSubscribeMessage][reqDTO({}) \u53d1\u9001\u8ba2\u9605\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f1a\u5458 openid \u7f3a\u5931]", (Object)reqDTO);
            return CommonResult.success((Object)false);
        }
        this.socialClientService.sendSubscribeMessage(reqDTO, template.getPriTmplId(), socialUser.getOpenid());
        return CommonResult.success((Object)true);
    }
}

