/*
 * Decompiled with CFR 0.152.
 */
package org.openea.eap.module.system.api.user;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.openea.eap.framework.common.pojo.CommonResult;
import org.openea.eap.framework.common.util.collection.CollectionUtils;
import org.openea.eap.framework.common.util.object.BeanUtils;
import org.openea.eap.module.system.api.user.AdminUserApi;
import org.openea.eap.module.system.api.user.dto.AdminUserRespDTO;
import org.openea.eap.module.system.dal.dataobject.dept.DeptDO;
import org.openea.eap.module.system.dal.dataobject.user.AdminUserDO;
import org.openea.eap.module.system.service.dept.DeptService;
import org.openea.eap.module.system.service.user.AdminUserService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class AdminUserApiImpl
implements AdminUserApi {
    @Resource
    private AdminUserService userService;
    @Resource
    private DeptService deptService;

    public CommonResult<AdminUserRespDTO> getUser(Long id) {
        AdminUserDO user = this.userService.getUser(id);
        return CommonResult.success((Object)((AdminUserRespDTO)BeanUtils.toBean((Object)user, AdminUserRespDTO.class)));
    }

    public CommonResult<List<AdminUserRespDTO>> getUserListBySubordinate(Long id) {
        AdminUserDO user = this.userService.getUser(id);
        if (user == null) {
            return CommonResult.success(Collections.emptyList());
        }
        ArrayList<Long> deptIds = new ArrayList<Long>();
        DeptDO dept = this.deptService.getDept(user.getDeptId());
        if (dept == null) {
            return CommonResult.success(Collections.emptyList());
        }
        if (ObjUtil.notEqual((Object)dept.getLeaderUserId(), (Object)id)) {
            return CommonResult.success(Collections.emptyList());
        }
        deptIds.add(dept.getId());
        List childDeptList = this.deptService.getChildDeptList(dept.getId());
        if (CollUtil.isNotEmpty((Collection)childDeptList)) {
            deptIds.addAll(CollectionUtils.convertSet((Collection)childDeptList, DeptDO::getId));
        }
        List users = this.userService.getUserListByDeptIds(deptIds);
        users.removeIf(item -> ObjUtil.equal((Object)item.getId(), (Object)id));
        return CommonResult.success((Object)BeanUtils.toBean((List)users, AdminUserRespDTO.class));
    }

    public CommonResult<List<AdminUserRespDTO>> getUserList(Collection<Long> ids) {
        List users = this.userService.getUserList(ids);
        return CommonResult.success((Object)BeanUtils.toBean((List)users, AdminUserRespDTO.class));
    }

    public CommonResult<List<AdminUserRespDTO>> getUserListByDeptIds(Collection<Long> deptIds) {
        List users = this.userService.getUserListByDeptIds(deptIds);
        return CommonResult.success((Object)BeanUtils.toBean((List)users, AdminUserRespDTO.class));
    }

    public CommonResult<List<AdminUserRespDTO>> getUserListByPostIds(Collection<Long> postIds) {
        List users = this.userService.getUserListByPostIds(postIds);
        return CommonResult.success((Object)BeanUtils.toBean((List)users, AdminUserRespDTO.class));
    }

    public CommonResult<Boolean> validateUserList(Collection<Long> ids) {
        this.userService.validateUserList(ids);
        return CommonResult.success((Object)true);
    }
}

