/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pl.project13.core.CommitIdGenerationMode;
import pl.project13.core.CommitIdPropertiesOutputFormat;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.GitDataProvider;
import pl.project13.core.JGitProvider;
import pl.project13.core.NativeGitProvider;
import pl.project13.core.PropertiesFileGenerator;
import pl.project13.core.PropertiesFilterer;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.git.GitDescribeConfig;
import pl.project13.core.log.LogInterface;
import pl.project13.core.util.BuildFileChangeListener;
import pl.project13.core.util.GitDirLocator;

public class GitCommitIdPlugin {
    protected static final Pattern allowedCharactersForEvaluateOnCommit = Pattern.compile("[a-zA-Z0-9\\_\\-\\^\\/\\.]+");

    public static void runPlugin(@Nonnull Callback cb, @Nullable Properties contextProperties) throws GitCommitIdExecutionException {
        PropertiesFilterer propertiesFilterer = new PropertiesFilterer(cb.getLogInterface());
        Properties properties = contextProperties == null ? new Properties() : contextProperties;
        GitCommitIdPlugin.loadGitData(cb, properties);
        GitCommitIdPlugin.loadBuildData(cb, properties);
        propertiesFilterer.filter(properties, cb.getIncludeOnlyProperties(), cb.getPrefixDot());
        propertiesFilterer.filterNot(properties, cb.getExcludeProperties(), cb.getPrefixDot());
        cb.performPublishToAllSystemEnvironments(properties);
        cb.performPropertiesReplacement(properties);
        if (cb.shouldGenerateGitPropertiesFile()) {
            new PropertiesFileGenerator(cb.getLogInterface(), cb.getBuildFileChangeListener(), cb.getPropertiesOutputFormat(), cb.getPrefixDot(), cb.getProjectName()).maybeGeneratePropertiesFile(properties, cb.getProjectBaseDir(), cb.getGenerateGitPropertiesFile(), cb.getPropertiesSourceCharset(), cb.shouldPropertiesEscapeUnicode());
        }
        cb.performPublishToAllSystemEnvironments(properties);
    }

    protected static void loadBuildData(@Nonnull Callback cb, @Nonnull Properties properties) throws GitCommitIdExecutionException {
        Map<String, Supplier<String>> additionalProperties = Collections.singletonMap("build.version", cb.supplyProjectVersion());
        BuildServerDataProvider buildServerDataProvider = BuildServerDataProvider.getBuildServerProvider(cb.getSystemEnv(), cb.getLogInterface());
        buildServerDataProvider.setDateFormat(cb.getDateFormat()).setDateFormatTimeZone(cb.getDateFormatTimeZone()).setAdditionalProperties(additionalProperties).setPrefixDot(cb.getPrefixDot()).setExcludeProperties(cb.getExcludeProperties()).setIncludeOnlyProperties(cb.getIncludeOnlyProperties());
        buildServerDataProvider.loadBuildData(properties, cb.getReproducibleBuildOutputTimestamp());
    }

    protected static void loadGitData(@Nonnull Callback cb, @Nonnull Properties properties) throws GitCommitIdExecutionException {
        String evaluateOnCommit = cb.getEvaluateOnCommit();
        if (evaluateOnCommit == null || !allowedCharactersForEvaluateOnCommit.matcher(evaluateOnCommit).matches()) {
            throw new GitCommitIdExecutionException("suspicious argument for evaluateOnCommit, aborting execution!");
        }
        File dotGitDirectory = new GitDirLocator(cb.getProjectBaseDir(), cb.useNativeGit(), cb.shouldFailOnNoGitDirectory()).lookupGitDirectory(cb.getDotGitDirectory());
        if (dotGitDirectory == null) {
            cb.getLogInterface().info("dotGitDirectory is null, aborting execution!");
            return;
        }
        cb.getLogInterface().info("dotGitDirectory '" + dotGitDirectory.getAbsolutePath() + "'");
        if (cb.useNativeGit()) {
            GitCommitIdPlugin.loadGitDataWithNativeGit(cb, dotGitDirectory, properties);
        } else {
            GitCommitIdPlugin.loadGitDataWithJGit(cb, dotGitDirectory, properties);
        }
    }

    private static void loadGitDataWithNativeGit(@Nonnull Callback cb, @Nonnull File dotGitDirectory, @Nonnull Properties properties) throws GitCommitIdExecutionException {
        GitDataProvider nativeGitProvider = NativeGitProvider.on(dotGitDirectory, cb.getNativeGitTimeoutInMs(), cb.getLogInterface()).setPrefixDot(cb.getPrefixDot()).setAbbrevLength(cb.getAbbrevLength()).setDateFormat(cb.getDateFormat()).setDateFormatTimeZone(cb.getDateFormatTimeZone()).setGitDescribe(cb.getGitDescribe()).setCommitIdGenerationMode(cb.getCommitIdGenerationMode()).setUseBranchNameFromBuildEnvironment(cb.getUseBranchNameFromBuildEnvironment()).setExcludeProperties(cb.getExcludeProperties()).setIncludeOnlyProperties(cb.getIncludeOnlyProperties()).setOffline(cb.isOffline());
        nativeGitProvider.loadGitData(cb.getEvaluateOnCommit(), cb.getSystemEnv(), properties);
    }

    private static void loadGitDataWithJGit(@Nonnull Callback cb, @Nonnull File dotGitDirectory, @Nonnull Properties properties) throws GitCommitIdExecutionException {
        GitDataProvider jGitProvider = JGitProvider.on(dotGitDirectory, cb.getLogInterface()).setPrefixDot(cb.getPrefixDot()).setAbbrevLength(cb.getAbbrevLength()).setDateFormat(cb.getDateFormat()).setDateFormatTimeZone(cb.getDateFormatTimeZone()).setGitDescribe(cb.getGitDescribe()).setCommitIdGenerationMode(cb.getCommitIdGenerationMode()).setUseBranchNameFromBuildEnvironment(cb.getUseBranchNameFromBuildEnvironment()).setExcludeProperties(cb.getExcludeProperties()).setIncludeOnlyProperties(cb.getIncludeOnlyProperties()).setOffline(cb.isOffline());
        jGitProvider.loadGitData(cb.getEvaluateOnCommit(), cb.getSystemEnv(), properties);
    }

    public static interface Callback {
        default public Map<String, String> getSystemEnv() {
            return System.getenv();
        }

        public Supplier<String> supplyProjectVersion();

        @Nonnull
        public LogInterface getLogInterface();

        @Nonnull
        public String getDateFormat();

        @Nonnull
        public String getDateFormatTimeZone();

        @Nonnull
        public String getPrefixDot();

        public List<String> getExcludeProperties();

        public List<String> getIncludeOnlyProperties();

        @Nullable
        public Date getReproducibleBuildOutputTimestamp() throws GitCommitIdExecutionException;

        public boolean useNativeGit();

        public long getNativeGitTimeoutInMs();

        public int getAbbrevLength();

        public GitDescribeConfig getGitDescribe();

        public CommitIdGenerationMode getCommitIdGenerationMode();

        public boolean getUseBranchNameFromBuildEnvironment();

        public boolean isOffline();

        public String getEvaluateOnCommit();

        public File getDotGitDirectory();

        public boolean shouldGenerateGitPropertiesFile();

        public void performPublishToAllSystemEnvironments(Properties var1);

        public void performPropertiesReplacement(Properties var1);

        public CommitIdPropertiesOutputFormat getPropertiesOutputFormat();

        public BuildFileChangeListener getBuildFileChangeListener();

        public String getProjectName();

        public File getProjectBaseDir();

        public File getGenerateGitPropertiesFile();

        public Charset getPropertiesSourceCharset();

        public boolean shouldPropertiesEscapeUnicode();

        public boolean shouldFailOnNoGitDirectory();
    }
}

