/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LogInterface;

public class GitlabBuildServerData
extends BuildServerDataProvider {
    GitlabBuildServerData(LogInterface log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("GITLAB_CI");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String uniqueBuildNumber = this.env.getOrDefault("CI_PIPELINE_ID", "");
        String buildNumber = this.env.getOrDefault("CI_PIPELINE_IID", "");
        this.maybePut(properties, "build.number", () -> buildNumber);
        this.maybePut(properties, "build.number.unique", () -> uniqueBuildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = (String)this.env.get("CI_COMMIT_REF_NAME");
        this.log.info(String.format("Using environment variable based branch name. CI_COMMIT_REF_NAME = %s", environmentBasedBranch));
        return environmentBasedBranch;
    }
}

