/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.container.impl.module;

import java.util.LinkedHashSet;
import org.brijframework.container.impl.AbstractContainer;
import org.brijframework.container.module.ModuleContainer;
import org.brijframework.factories.Factory;
import org.brijframework.factories.module.ModuleFactory;
import org.brijframework.support.ordering.DepandOn;
import org.brijframework.support.ordering.OrderOn;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.AnnotationUtil;

public abstract class AbstractModuleContainer
extends AbstractContainer
implements ModuleContainer {
    private LinkedHashSet<Class<? extends ModuleFactory<?, ?>>> classList = new LinkedHashSet();

    public AbstractModuleContainer loadContainer() {
        LoggerConsole.screen((String)("ModuleContainer -> " + this.getClass().getSimpleName()), (String)("Strating to lunch the container for " + this.getClass().getSimpleName()));
        this.init();
        this.getOrderOnSortedFactoryList(this.getModuleFactories()).forEach(metaFactory -> {
            LoggerConsole.screen((String)("ModuleFactory -> " + metaFactory.getSimpleName()), (String)("Lunching the module factory for " + metaFactory.getSimpleName()));
            this.loadFactory((Class<? extends Factory<?, ?>>)metaFactory);
            LoggerConsole.screen((String)("ModuleFactory -> " + metaFactory.getSimpleName()), (String)("Lunched the module factory for " + metaFactory.getSimpleName()));
        });
        LoggerConsole.screen((String)("ModuleContainer -> " + this.getClass().getSimpleName()), (String)("Successfully lunch the container for " + this.getClass().getSimpleName()));
        return this;
    }

    protected LinkedHashSet<Class<? extends ModuleFactory<?, ?>>> getModuleFactories() {
        return this.classList;
    }

    protected void register(Class<? extends ModuleFactory<?, ?>> container) {
        Assertion.notNull(container, (String)"ModuleFactory class should not be null.");
        this.getModuleFactories().add(container);
    }

    protected LinkedHashSet<Class<? extends ModuleFactory<?, ?>>> getDepandOnSortedFactoryList(LinkedHashSet<Class<? extends ModuleFactory<?, ?>>> linkedHashSet) {
        LinkedHashSet list = new LinkedHashSet();
        linkedHashSet.stream().sorted((c1, c2) -> {
            if (c1.isAnnotationPresent(DepandOn.class)) {
                return -1;
            }
            if (c2.isAnnotationPresent(DepandOn.class)) {
                return 1;
            }
            return 0;
        }).forEach(factory -> this.fillDepandOnFactory(list, (Class<? extends ModuleFactory<?, ?>>)factory));
        return list;
    }

    private void fillDepandOnFactory(LinkedHashSet<Class<? extends ModuleFactory<?, ?>>> list, Class<? extends ModuleFactory<?, ?>> factory) {
        if (factory == null) {
            return;
        }
        if (factory.isAnnotationPresent(DepandOn.class)) {
            DepandOn depandOn = factory.getAnnotation(DepandOn.class);
            this.fillDepandOnFactory(list, depandOn.depand());
        }
        if (!list.contains(factory)) {
            list.add(factory);
        }
    }

    public Iterable<Class<? extends ModuleFactory<?, ?>>> getOrderOnSortedFactoryList(LinkedHashSet<Class<? extends ModuleFactory<?, ?>>> classList) {
        LinkedHashSet list = new LinkedHashSet();
        classList.stream().filter(c -> c.isAnnotationPresent(OrderOn.class)).sorted((c1, c2) -> {
            OrderOn orderOn1 = (OrderOn)AnnotationUtil.getAnnotation((Class)c1, OrderOn.class);
            OrderOn orderOn2 = (OrderOn)AnnotationUtil.getAnnotation((Class)c2, OrderOn.class);
            return Integer.compare(orderOn1.value(), orderOn2.value());
        }).forEach(factory -> list.add((Class<? extends ModuleFactory<?, ?>>)factory));
        classList.stream().filter(c -> !c.isAnnotationPresent(OrderOn.class)).forEach(factory -> list.add((Class<? extends ModuleFactory<?, ?>>)factory));
        return list;
    }

    public boolean containsObject(Object key) {
        return false;
    }
}

