/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.context.impl.bootstrap;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.brijframework.container.bootstrap.BootstrapContainer;
import org.brijframework.context.Context;
import org.brijframework.context.bootstrap.BootstrapContext;
import org.brijframework.context.impl.AbstractContext;
import org.brijframework.context.impl.Stages;
import org.brijframework.context.module.ModuleContext;
import org.brijframework.group.Group;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.support.util.SupportUtil;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.reflect.MethodUtil;

public abstract class AbstractBootstrapContext
extends AbstractContext
implements BootstrapContext {
    private ConcurrentHashMap<Object, BootstrapContainer> cache = new ConcurrentHashMap();
    private LinkedHashSet<Class<? extends BootstrapContainer>> classList;

    protected void loadContainer(Class<? extends BootstrapContainer> bootstrapContainerClass) {
        if (!InstanceUtil.isAssignable(bootstrapContainerClass)) {
            return;
        }
        if (!this.invokeFactoryMethod(bootstrapContainerClass)) {
            this.invokeInstanceMethod(bootstrapContainerClass);
        }
    }

    protected boolean invokeFactoryMethod(Class<? extends BootstrapContainer> bootstrapContainerClass) {
        for (Method method : MethodUtil.getAllMethod(bootstrapContainerClass)) {
            if (!method.isAnnotationPresent(SingletonFactory.class)) continue;
            try {
                BootstrapContainer bootstrapContainer = (BootstrapContainer)method.invoke(null, new Object[0]);
                this.register(bootstrapContainer);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected void invokeInstanceMethod(Class<? extends BootstrapContainer> bootstrapContainerClass) {
        try {
            BootstrapContainer bootstrapContainer = bootstrapContainerClass.newInstance();
            this.register(bootstrapContainer);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    protected void destoryContext(Class<? extends BootstrapContainer> containerClass) {
        if (!InstanceUtil.isAssignable(containerClass)) {
            return;
        }
        this.getContainers().remove(containerClass.getName());
        System.gc();
    }

    public void start() {
        if (Stages.START.equals((Object)this.getStages())) {
            System.err.println("Bootstrap container already started.");
            return;
        }
        this.init();
        if (this.getRegisteredList() == null || this.getRegisteredList().isEmpty()) {
            System.err.println("Bootstrap container should not be empty. please register context into @Override init method for :" + this.getClass().getSimpleName());
            return;
        }
        LoggerConsole.screen((String)("BootstrapContext -> " + this.getClass().getSimpleName()), (String)"Starting bootstrap context for loading the bootstrap container");
        this.getRegisteredList().forEach(Context2 -> this.loadContainer((Class<? extends BootstrapContainer>)Context2));
        this.setStages(Stages.START);
        LoggerConsole.screen((String)("BootstrapContext -> " + this.getClass().getSimpleName()), (String)"Started bootstrap context for loading the bootstrap container");
    }

    public void stop() {
        if (Stages.STOPED.equals((Object)this.getStages())) {
            System.err.println("Bootstrap container already stoped.");
            return;
        }
        if (this.getRegisteredList() == null || this.getRegisteredList().isEmpty()) {
            System.err.println("Bootstrap container should not be empty. please register context into @Override init method for :" + this.getClass().getSimpleName());
            return;
        }
        this.getRegisteredList().forEach(Context2 -> this.destoryContext((Class<? extends BootstrapContainer>)Context2));
        this.setStages(Stages.STOPED);
    }

    public ConcurrentHashMap<Object, BootstrapContainer> getContainers() {
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        return this.cache;
    }

    protected LinkedHashSet<Class<? extends BootstrapContainer>> getRegisteredList() {
        return SupportUtil.getDepandOnSortedBootstrapContainerList(this.getClassList());
    }

    public LinkedHashSet<Class<? extends BootstrapContainer>> getClassList() {
        if (this.classList == null) {
            this.classList = new LinkedHashSet();
        }
        return this.classList;
    }

    protected void register(Class<? extends BootstrapContainer> context) {
        Assertion.notNull(context, (String)"Context class should not be null.");
        this.getClassList().add(context);
    }

    protected void register(BootstrapContainer bootstrapContainer) {
        Assertion.notNull((Object)bootstrapContainer, (String)"bootstrap container should not be null.");
        bootstrapContainer.setContext((Context)this);
        bootstrapContainer.init();
        bootstrapContainer.loadContainer();
        this.getContainers().put(bootstrapContainer.getClass().getSimpleName(), bootstrapContainer);
    }

    public void poststart(BootstrapContainer container) {
    }

    public void prestart(BootstrapContainer container) {
    }

    public <T> T getContext(Class<T> moduleContextCls) {
        ConcurrentHashMap<Object, BootstrapContainer> containers = this.getContainers();
        for (Map.Entry<Object, BootstrapContainer> entry : containers.entrySet()) {
            BootstrapContainer bootstrapContainer = entry.getValue();
            for (Map.Entry entryGroup : bootstrapContainer.getCache().entrySet()) {
                ModuleContext find = (ModuleContext)((Group)entryGroup.getValue()).get((Object)moduleContextCls.getSimpleName());
                if (find == null) continue;
                return (T)find;
            }
        }
        return null;
    }
}

