/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.factories.impl;

import java.util.concurrent.ConcurrentHashMap;
import org.brijframework.container.Container;
import org.brijframework.context.Context;
import org.brijframework.env.Environment;
import org.brijframework.factories.Factory;
import org.brijframework.group.Group;

public abstract class AbstractFactory<K, T>
implements Factory<K, T> {
    Container container;
    ConcurrentHashMap<K, T> cache;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public ConcurrentHashMap<K, T> getCache() {
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        return this.cache;
    }

    public T getContainer(K modelKey) {
        if (this.getContainer() == null) {
            return null;
        }
        return (T)this.getContainer().find(modelKey);
    }

    public Factory<K, T> clear() {
        this.getCache().clear();
        return this;
    }

    public T register(K key, T value) {
        this.preregister(key, value);
        this.getCache().put(key, value);
        this.loadContainer(key, value);
        this.postregister(key, value);
        return value;
    }

    public T find(K key) {
        if (this.getCache().containsKey(key)) {
            return this.getCache().get(key);
        }
        return this.getContainer(key);
    }

    public Object getEnvProperty(String key) {
        Container container = this.getContainer();
        if (container == null) {
            return null;
        }
        Context context = container.getContext();
        if (context == null) {
            return null;
        }
        Environment environment = context.getEnvironment();
        if (environment == null) {
            return null;
        }
        return environment.get(key);
    }

    public boolean contains(K key) {
        if (this.getCache().containsKey(key)) {
            return true;
        }
        return this.getContainer().containsObject(key);
    }

    protected abstract void preregister(K var1, T var2);

    protected abstract void postregister(K var1, T var2);

    public void loadContainer(K key, T value) {
        if (this.getContainer() == null) {
            return;
        }
        Group group = this.getContainer().load((Object)value.getClass().getName());
        if (!group.containsKey(key)) {
            group.add(key, value);
        } else {
            group.update(key, value);
        }
    }
}

