/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.resources.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.brijframework.resources.Resource;

public interface DefaultResource
extends Resource {
    default public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    default public long contentLength() {
        return new String(this.getContent()).length();
    }

    default public long lastModified() {
        return this.getFile().lastModified();
    }

    default public String getFilename() {
        return this.getFile().getName();
    }

    default public byte[] getContent() {
        try {
            InputStream stream = this.getInputStream();
            byte[] bs = new byte[stream.available()];
            stream.read(bs);
            stream.close();
            return bs;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    default public String getResource() {
        return new String(this.getContent());
    }

    default public boolean exists() {
        return this.getFile().exists();
    }

    default public URI getURI() throws URISyntaxException {
        return this.getFile().toURI();
    }

    default public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    default public String getExtension() {
        return this.getFilename().substring(this.getFilename().lastIndexOf(".") + 1, this.getFilename().length());
    }
}

