/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.factories.impl.bootstrap.env;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.brijframework.env.Environment;
import org.brijframework.env.impl.EnvironmentImpl;
import org.brijframework.factories.impl.bootstrap.AbstractBootstrapFactory;
import org.brijframework.group.Group;
import org.brijframework.support.app.EnvironmentResource;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.support.ordering.OrderOn;
import org.brijframework.util.factories.ReflectionFactory;
import org.brijframework.util.objects.PropertiesUtil;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.resouces.ResourcesUtil;
import org.brijframework.util.resouces.YamlUtil;
import org.brijframework.util.text.StringUtil;

@OrderOn(value=0)
public class EnvironmentFactory
extends AbstractBootstrapFactory<String, Environment> {
    private static final String prefix_filepath = "filepath:";
    private static final String prefix_classpath = "classpath:";
    private static EnvironmentFactory factory;

    @SingletonFactory
    public static EnvironmentFactory getFactory() {
        if (factory == null) {
            factory = new EnvironmentFactory();
        }
        return factory;
    }

    public EnvironmentFactory loadFactory() {
        try {
            LoggerConsole.screen((String)("BootstrapFactory -> " + this.getClass().getSimpleName()), (String)"Lunching the factory for ResourceContext");
            String environmentLocation = System.getProperty("application.environment.location");
            String environmentFiles = System.getProperty("application.environment.files");
            ArrayList<String> environmentPaths = new ArrayList<String>();
            if (StringUtil.isEmpty((String)environmentFiles)) {
                for (Class cls : ReflectionFactory.getFactory().getInternalClassList()) {
                    if (!cls.isAnnotationPresent(EnvironmentResource.class)) continue;
                    EnvironmentResource resource = cls.getAnnotation(EnvironmentResource.class);
                    environmentLocation = resource.location();
                    environmentFiles = resource.value();
                }
            }
            if (StringUtil.isEmpty((String)environmentFiles)) {
                environmentLocation = prefix_classpath;
                environmentFiles = "application-environment.properties|application-environment.yaml|application-environment.yml|application-environment.xml";
            }
            this.loadEnviroment(environmentLocation, environmentFiles, environmentPaths);
            for (String environmentPath : environmentPaths) {
                try {
                    if (environmentPath.startsWith(prefix_classpath)) {
                        this.loadClassPathResource(environmentPath);
                    }
                    if (!environmentPath.startsWith(prefix_filepath)) continue;
                    this.loadFilePathResource(environmentPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.setActiveProfile();
            Environment environment = this.getEnvironment();
            LoggerConsole.screen((String)"APPLICATION_ENVIRONMENT_RESOURCE", (String)((Object)environmentPaths).toString());
            LoggerConsole.screen((String)"environment", (String)("Active profile :" + environment.getName()));
            LoggerConsole.screen((String)("BootstrapFactory -> " + this.getClass().getSimpleName()), (String)"Lunched the factory for ResourceContext");
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerConsole.screen((String)("BootstrapFactory -> " + this.getClass().getSimpleName()), (String)"Error to lunch the factory for ResourceContext");
        }
        return this;
    }

    private void loadFilePathResource(String environmentPath) {
    }

    private void loadClassPathResource(String environmentPath) {
        URL resource = ResourcesUtil.getResource((String)environmentPath.replace(prefix_classpath, ""));
        if (resource == null) {
            return;
        }
        if (environmentPath.toString().endsWith("properties")) {
            Properties envProperties = PropertiesUtil.getProperties((File)new File(resource.getFile()));
            this.environment(envProperties);
        }
        if (environmentPath.toString().endsWith("yml") || environmentPath.toString().endsWith("yaml")) {
            try {
                String[] profiles;
                for (String profile : profiles = new String(Files.readAllBytes(new File(resource.getFile()).toPath())).split("---")) {
                    Properties envProperties = YamlUtil.getEnvProperties((String)profile);
                    this.environment(envProperties);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void environment(Properties envProperties) {
        String profileName = envProperties.getProperty("application.profiles");
        if (profileName == null) {
            profileName = "default";
        }
        EnvironmentImpl environment = new EnvironmentImpl();
        environment.setActive(false);
        environment.setName(profileName);
        environment.setProperties(envProperties);
        this.register(profileName, environment);
    }

    private void setActiveProfile() {
        if (this.getCache().isEmpty()) {
            Properties envProperties = new Properties();
            this.environment(envProperties);
        }
        for (Environment environment : this.getCache().values()) {
            EnvironmentImpl environmentImpl;
            String activePrfile = (String)environment.getProperties().get("application.profiles.active");
            if (activePrfile == null || (environmentImpl = (EnvironmentImpl)this.getCache().get(activePrfile)) == null) continue;
            environmentImpl.setActive(true);
        }
    }

    private void loadEnviroment(String environmentLocation, String environmentFiles, List<String> environmentPaths) {
        for (String environmentFile : environmentFiles.split("\\|")) {
            environmentPaths.add(StringUtil.isNonEmpty((String)environmentLocation) ? environmentLocation + "" + environmentFile : environmentFile);
        }
    }

    @Override
    protected void preregister(String key, Environment value) {
    }

    @Override
    protected void postregister(String key, Environment value) {
    }

    @Override
    public void loadContainer(String key, Environment value) {
        if (this.getContainer() == null) {
            return;
        }
        Group group = this.getContainer().load((Object)value.getClass().getName());
        if (!group.containsKey((Object)key)) {
            group.add((Object)key, (Object)value);
        } else {
            group.update((Object)key, (Object)value);
        }
    }

    public Environment getEnvironment() {
        for (Environment environment : this.getCache().values()) {
            if (!environment.isActive()) continue;
            return environment;
        }
        return (Environment)this.getCache().get("default");
    }
}

