/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.bean.factories.resource.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brijframework.bean.config.impl.BeanConfigration;
import org.brijframework.bean.factories.resource.asm.AbstractBeanResourceFactory;
import org.brijframework.bean.resource.impl.BeanResourceImpl;
import org.brijframework.model.factories.resource.impl.DefaultTypeModelResourceFactory;
import org.brijframework.resources.factory.json.JsonResourceFactory;
import org.brijframework.resources.files.json.JsonResource;
import org.brijframework.support.enums.Scope;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.support.ordering.OrderOn;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.ClassUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.text.StringUtil;
import org.json.JSONException;

@OrderOn(value=2)
public class JsonBeanResourceFactory
extends AbstractBeanResourceFactory {
    private static JsonBeanResourceFactory factory;

    @SingletonFactory
    public static JsonBeanResourceFactory getFactory() {
        if (factory == null) {
            factory = new JsonBeanResourceFactory();
        }
        return factory;
    }

    public List<BeanConfigration> configration() {
        Object resources = this.getEnvProperty("application.bean.config");
        if (resources == null) {
            LoggerConsole.screen((String)"BeanConfigration", (String)"Bean configration not found :application.bean.config");
            return null;
        }
        LoggerConsole.screen((String)"BeanConfigration", (String)("Bean configration found :application.bean.config | " + resources));
        if (resources instanceof List) {
            return this.build((List)resources);
        }
        if (resources instanceof Map) {
            return this.build((Map)resources);
        }
        HashMap<String, Object> resourcesMap = new HashMap<String, Object>();
        resourcesMap.put("location", resources);
        resourcesMap.put("enable", this.getEnvProperty("application.bean.config.enable"));
        return this.build(resourcesMap);
    }

    private List<BeanConfigration> build(Map<String, Object> resource) {
        ArrayList<BeanConfigration> configs = new ArrayList<BeanConfigration>();
        configs.add((BeanConfigration)InstanceUtil.getInstance(BeanConfigration.class, resource));
        return configs;
    }

    private List<BeanConfigration> build(List<Map<String, Object>> resources) {
        ArrayList<BeanConfigration> configs = new ArrayList<BeanConfigration>();
        for (Map<String, Object> resource : resources) {
            configs.add((BeanConfigration)InstanceUtil.getInstance(BeanConfigration.class, resource));
        }
        return configs;
    }

    @Override
    public JsonBeanResourceFactory loadFactory() {
        List<BeanConfigration> configs = this.configration();
        if (configs == null) {
            LoggerConsole.screen((String)"BeanConfigration", (String)("Invalid bean configration : " + configs));
            return this;
        }
        for (BeanConfigration modelConfig : configs) {
            if (!modelConfig.isEnable()) {
                LoggerConsole.screen((String)"BeanConfigration", (String)("Bean configration disabled found :" + modelConfig.getLocation()));
            }
            Collection resources = JsonResourceFactory.factory().getResources((Object)modelConfig.getLocation());
            System.out.println(modelConfig.getLocation() + "==resources=" + resources);
            this.registerResource(resources);
        }
        return this;
    }

    private void registerResource(Collection<JsonResource> resources) {
        for (JsonResource resource : resources) {
            if (resource.isJsonList()) {
                try {
                    this.register(resource.toObjectList());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (!resource.isJsonObject()) continue;
            try {
                this.register(resource.toObjectMap());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void register(List<Object> resources) {
        Assertion.notNull(resources, (String)"Invalid resources");
        for (Object object : resources) {
            if (!(object instanceof Map)) continue;
            this.register((Map)object);
        }
    }

    public void register(Map<String, Object> resourceMap) {
        Assertion.notNull(resourceMap, (String)("Invalid resource :" + resourceMap));
        BeanResourceImpl beanResource = (BeanResourceImpl)InstanceUtil.getInstance(BeanResourceImpl.class, resourceMap);
        String id = (String)resourceMap.remove("id");
        String type = (String)resourceMap.remove("type");
        String model = (String)resourceMap.remove("model");
        String name = (String)resourceMap.remove("name");
        String scope = (String)resourceMap.get("scope");
        String factoryClass = (String)resourceMap.get("factory-class");
        String factoryMethod = (String)resourceMap.get("factory-method");
        if (StringUtil.isEmpty((String)scope)) {
            scope = Scope.SINGLETON.toString();
        }
        Assertion.isTrue((StringUtil.isEmpty((String)type) && StringUtil.isEmpty((String)model) ? 1 : 0) != 0, (String)"Invalid type or model for BeanResource");
        if (StringUtil.isNonEmpty((String)type)) {
            Class typeClass = ClassUtil.getClass((String)type);
            Assertion.notEmpty((Object)typeClass, (String)"Not found type for BeanResource");
            if (StringUtil.isEmpty((String)name)) {
                name = typeClass.getSimpleName();
            }
            if (StringUtil.isEmpty((String)model)) {
                model = typeClass.getSimpleName();
                DefaultTypeModelResourceFactory.getFactory().createOrload(typeClass);
            }
        }
        Assertion.notEmpty((Object)id, (String)"Invalid id for BeanResource");
        beanResource.setId(id);
        beanResource.setName(name);
        beanResource.setScope(scope);
        beanResource.setType(type);
        beanResource.setModel(model);
        beanResource.setFactoryClass(factoryClass);
        beanResource.setFactoryMethod(factoryMethod);
        beanResource.getProperties().putAll((Map)resourceMap.get("properties"));
        this.register(beanResource.getId(), beanResource);
    }
}

