/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.resources.csv;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brijframework.resources.csv.CsvMapper;
import org.brijframework.resources.csv.CsvModel;
import org.brijframework.resources.csv.RowObject;

public abstract class CsvLoader {
    public List<RowObject> insertArray = new ArrayList<RowObject>();
    public List<RowObject> updateArray = new ArrayList<RowObject>();
    public List<RowObject> extraArray = new ArrayList<RowObject>();
    public List<RowObject> failedArray = new ArrayList<RowObject>();
    private CsvModel csvModel;

    public void setCsvModel(CsvModel csvModel) {
        this.csvModel = csvModel;
    }

    public CsvModel getCsvModel() {
        return this.csvModel;
    }

    public abstract CsvModel getKeysMapper();

    public abstract Collection<?> dataArray();

    public boolean isContainRecord(Map<String, Object> contains) {
        for (Object oldObject : this.dataArray()) {
            Object newValue;
            Object oldValue;
            if (oldObject instanceof Map) {
                Map mapObject = (Map)oldObject;
                Set<Map.Entry<String, Object>> entries = contains.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    oldValue = mapObject.get(entry.getKey());
                    newValue = contains.get(entry.getKey());
                    if (oldValue == null && newValue == null || !oldValue.toString().equals(newValue.toString())) continue;
                    return true;
                }
                continue;
            }
            if (oldObject instanceof Collection) {
                System.err.println("collection is not allowed");
                continue;
            }
            Set<Map.Entry<String, Object>> entries = contains.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                try {
                    Field field = oldObject.getClass().getDeclaredField(entry.getKey().toString());
                    field.setAccessible(true);
                    oldValue = field.get(oldObject);
                    newValue = contains.get(entry.getKey());
                    if (oldValue == null && newValue == null || !oldValue.toString().equals(newValue.toString())) continue;
                    return true;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public void loadFromCsvFile(File file) throws IOException {
        StringBuilder buffer = new StringBuilder();
        FileReader fileReader = new FileReader(file);
        int data = ((Reader)fileReader).read();
        while (data != -1) {
            buffer.append((char)data);
            data = ((Reader)fileReader).read();
        }
        ((Reader)fileReader).close();
        this.loadFromCsvBuffer(buffer.toString());
    }

    public void loadFromCsvBuffer(String csvData) {
        if (csvData == null || csvData.isEmpty()) {
            return;
        }
        String[] csvDataArray = csvData.trim().split("\n");
        if (csvDataArray.length == 0) {
            System.err.println("Invalid csv file ");
        }
        String[] headerKeys = csvDataArray[0].split(",");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 1; i < csvDataArray.length; ++i) {
            if (csvDataArray[i].trim().isEmpty()) continue;
            String[] dataValues = csvDataArray[i].trim().split(",");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < headerKeys.length; ++j) {
                String key = headerKeys[j];
                String value = "";
                if (j < dataValues.length) {
                    value = dataValues[j];
                }
                map.put(key, value);
            }
            list.add(map);
        }
        this.loadFromCsvArray(list);
    }

    public void loadFromCsvArray(List<Map<String, Object>> csvArray) {
        for (Map<String, Object> csvHash : csvArray) {
            RowObject rowObject = new RowObject();
            rowObject.csvObject = csvHash;
            rowObject.rowObject = this.mappedHash(csvHash);
            if (!this.isValidRecord(csvHash)) {
                rowObject.isError = true;
                rowObject.message = this.errorMsg(csvHash);
                this.failedArray.add(rowObject);
                continue;
            }
            if (this.isExtraRecord(csvHash)) {
                rowObject.isError = true;
                rowObject.message = this.extraMsg(csvHash);
                this.extraArray.add(rowObject);
                continue;
            }
            boolean isUpdate = this.isContainRecord(rowObject.rowObject);
            if (isUpdate) {
                this.updateArray.add(rowObject);
                continue;
            }
            this.insertArray.add(rowObject);
        }
    }

    public boolean isExtraRecord(Map<String, Object> csvHash) {
        CsvModel csvModel = this.getKeysMapper();
        Map<String, CsvMapper> csvfieldHash = csvModel.csvFieldHash();
        for (String mappedkey : csvHash.keySet()) {
            CsvMapper field = csvfieldHash.get(mappedkey);
            if (field != null) continue;
            return true;
        }
        return false;
    }

    public boolean isValidRecord(Map<String, Object> csvHash) {
        CsvModel csvModel = this.getKeysMapper();
        Map<String, CsvMapper> csvfieldHash = csvModel.csvFieldHash();
        for (String mappedkey : csvfieldHash.keySet()) {
            CsvMapper field = csvfieldHash.get(mappedkey);
            if (!field.isRequied || this.mappedKey(csvHash, field.headerkey) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isExistsRecord(Map<String, Object> csvHash) {
        CsvModel csvModel = this.getKeysMapper();
        Map<String, CsvMapper> mdlfieldHash = csvModel.mdlFieldHash();
        HashMap<String, Object> contains = new HashMap<String, Object>();
        for (String key : csvModel.uniqueKeys.split("~")) {
            contains.put(key, this.mappedValue(csvHash, mdlfieldHash.get((Object)key).headerkey));
        }
        return this.isContainRecord(contains);
    }

    public String extraMsg(Map<String, Object> csvHash) {
        StringBuilder builder = new StringBuilder();
        CsvModel csvModel = this.getKeysMapper();
        Map<String, CsvMapper> csvfieldHash = csvModel.csvFieldHash();
        int count = 0;
        int size = csvHash.keySet().size();
        for (String key : csvHash.keySet()) {
            CsvMapper mappedKey = csvfieldHash.get(key);
            if (mappedKey == null) {
                builder.append("\"" + key + "\" key is remove from extra keys");
            }
            if (++count >= size) continue;
            builder.append(" , ");
        }
        return builder.toString();
    }

    public String errorMsg(Map<String, Object> csvHash) {
        StringBuilder builder = new StringBuilder();
        CsvModel csvModel = this.getKeysMapper();
        Map<String, CsvMapper> csvfieldHash = csvModel.csvFieldHash();
        int count = 0;
        int size = csvfieldHash.keySet().size();
        for (String key : csvfieldHash.keySet()) {
            String mappedKey = this.mappedKey(csvHash, key);
            if (mappedKey == null) {
                builder.append("\"" + key + "\"");
            }
            if (++count < size) {
                builder.append(" , ");
            }
            if (count != size) continue;
            builder.append(" key is missing");
        }
        return builder.toString();
    }

    protected String mappedKey(Map<String, Object> csvHash, String key) {
        for (String cKey : csvHash.keySet()) {
            if (!cKey.equalsIgnoreCase(key)) continue;
            return cKey;
        }
        return null;
    }

    protected Object mappedValue(Map<String, Object> csvHash, String key) {
        String mappedKey = this.mappedKey(csvHash, key);
        return mappedKey != null ? csvHash.get(mappedKey) : null;
    }

    public Map<String, Object> mappedHash(Map<String, Object> csvHash) {
        HashMap<String, Object> mappedHash = new HashMap<String, Object>();
        CsvModel csvModel = this.getKeysMapper();
        Map<String, CsvMapper> csvfieldHash = csvModel.csvFieldHash();
        for (String mappedkey : csvfieldHash.keySet()) {
            CsvMapper validation = csvfieldHash.get(mappedkey);
            mappedHash.put(validation.mappedkey, csvHash.get(this.mappedKey(csvHash, validation.headerkey)));
        }
        return mappedHash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\n");
        buffer.append("\ninsertArray=" + this.insertArray);
        buffer.append("\nupdateArray=" + this.updateArray);
        buffer.append("\nextraArray =" + this.extraArray);
        buffer.append("\nfailedArray=" + this.failedArray);
        buffer.append("\n}");
        return buffer.toString();
    }
}

