/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.resources.factory.asm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.brijframework.factories.impl.AbstractFactory;
import org.brijframework.resources.Resource;
import org.brijframework.resources.config.impl.ResourceConfigration;
import org.brijframework.resources.factory.ResourceFactory;
import org.brijframework.resources.locator.ResourceLocator;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.resouces.ResourcesUtil;

public abstract class AbstractResourceFactory<K, T extends Resource>
extends AbstractFactory<K, T>
implements ResourceFactory<K, T> {
    public ResourceFactory<K, T> loadFactory() {
        LoggerConsole.screen((String)("ResourceFactory -> " + this.getClass().getSimpleName()), (String)"Lunching factory to load resource");
        this.clear();
        List<ResourceConfigration> configs = this.getConfigration();
        if (configs == null) {
            LoggerConsole.screen((String)"ResourceConfigration", (String)("Invalid Resource configration : " + configs));
            return this;
        }
        for (ResourceConfigration modelConfig : configs) {
            if (!modelConfig.isEnable()) {
                LoggerConsole.screen((String)"ResourceConfigration", (String)("Resource configration disabled found :" + modelConfig.getLocation()));
                continue;
            }
            try {
                String dirPath = modelConfig.getLocation().startsWith("classpath:") ? modelConfig.getLocation().split("classpath:")[1] : modelConfig.getLocation();
                for (File file : ResourcesUtil.getResources((String)dirPath, (String[])new String[0])) {
                    if (!file.getName().endsWith(this.getResourceType()) || this.isIgnoreFile(file)) continue;
                    String id = null;
                    id = file.getAbsolutePath().contains("classes") ? ResourceLocator.CLASSPATH.getLocator() + file.getAbsolutePath().split("classes")[1] : ResourceLocator.FILEPATH.getLocator() + file.getAbsolutePath();
                    Resource resource = this.build(id, file);
                    if (resource == null) continue;
                    LoggerConsole.screen((String)"Resource ", (String)("Load resource with id : " + resource.getId()));
                    this.load(resource);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LoggerConsole.screen((String)("ResourceFactory -> " + this.getClass().getSimpleName()), (String)"Lunched factory to load resource");
        return this;
    }

    @Override
    public Collection<T> getResources() {
        return this.getCache().values();
    }

    @Override
    public Collection<T> getResources(K dir) {
        String dirPath = dir.toString().startsWith("classpath:") ? dir.toString().split("classpath:")[1] : dir.toString();
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource resource : this.getCache().values()) {
            String absolutePath = resource.getFile().getAbsolutePath();
            String[] paths = absolutePath.split("classes");
            if (paths.length < 1 || !paths[1].startsWith(dirPath.replace('/', '\\').replace('\\', '\\'))) continue;
            list.add(resource);
        }
        return list;
    }

    public List<ResourceConfigration> getConfigration() {
        List<ResourceConfigration> configrations = new ArrayList<ResourceConfigration>();
        Object resources = this.getContainer().getContext().getEnvironment().get("application.resource.config");
        if (resources == null) {
            LoggerConsole.screen((String)"ResourceConfigration", (String)"Resource configration not found :application.resource.config");
        } else {
            LoggerConsole.screen((String)"ResourceConfigration", (String)("Resource configration found :application.resource.config | " + resources));
            if (resources instanceof List) {
                configrations = this.build((List)resources);
            } else if (resources instanceof Map) {
                configrations = this.build((Map)resources);
            }
        }
        if (configrations.isEmpty()) {
            configrations.add(new ResourceConfigration("", true));
        }
        return configrations;
    }

    private List<ResourceConfigration> build(Map<String, Object> resource) {
        ArrayList<ResourceConfigration> configs = new ArrayList<ResourceConfigration>();
        configs.add((ResourceConfigration)InstanceUtil.getInstance(ResourceConfigration.class, resource));
        return configs;
    }

    private List<ResourceConfigration> build(List<Map<String, Object>> resources) {
        ArrayList<ResourceConfigration> configs = new ArrayList<ResourceConfigration>();
        for (Map<String, Object> resource : resources) {
            configs.add((ResourceConfigration)InstanceUtil.getInstance(ResourceConfigration.class, resource));
        }
        return configs;
    }
}

