/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.accessor;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.brijframework.util.accessor.MetaAccessorUtil;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.casting.CastingUtil;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.support.ReflectionAccess;

public class PropertyAccessorUtil {
    public static <T> T setProperty(Object bean, String field, Object value) {
        Assertion.notNull(field, "this arg is required; it must not be null");
        return PropertyAccessorUtil.setProperty(bean, field, ReflectionAccess.PUBLIC, value);
    }

    public static <T> T setProperty(Object bean, String field, ReflectionAccess access, Object value) {
        Assertion.notNull(field, "this arg is required; it must not be null");
        AccessibleObject colling = MetaAccessorUtil.setPropertyMeta(bean.getClass(), field, ReflectionAccess.PRIVATE, value);
        Assertion.notNull(colling, "passing argument with unbounded key " + field + " for " + bean.getClass());
        return PropertyAccessorUtil.setProperty(bean, colling, access, value);
    }

    public static <T> T setProperty(Object bean, AccessibleObject colling, ReflectionAccess access, Object value) {
        Assertion.notNull(colling, "this arg is required; it must not be null");
        try {
            if (colling instanceof Method) {
                return PropertyAccessorUtil.setProperty(bean, (Method)colling, access, value);
            }
            if (colling instanceof Field) {
                return PropertyAccessorUtil.setProperty(bean, (Field)colling, access, value);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <T> T setProperty(Object bean, Method colling, ReflectionAccess access, Object value) {
        Assertion.notNull(colling, "this arg is required; it must not be null");
        Assertion.isTrue(!access.isAccess(colling.getModifiers()), "Trying to illegal access " + colling.getName());
        try {
            colling.setAccessible(true);
            colling.invoke(bean, CastingUtil.castObject(value, colling.getParameterTypes()[0]));
            return (T)value;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public static <T> T setProperty(Object bean, Field colling, ReflectionAccess access, Object value) {
        Assertion.notNull(colling, "this arg is required; it must not be null");
        Assertion.isTrue(!access.isAccess(colling.getModifiers()), "Trying to illegal access " + colling.getName());
        try {
            colling.setAccessible(true);
            colling.set(bean, CastingUtil.castObject(value, colling.getType()));
            return (T)value;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getProperty(Object bean, String field) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        return PropertyAccessorUtil.getProperty(bean, field, ReflectionAccess.PUBLIC);
    }

    public static <T> T getProperty(Object bean, String field, ReflectionAccess level) {
        Assertion.notNull(bean, "Model object is required; it must not be null");
        Assertion.notNull(field, "this field name is required; it must not be null");
        AccessibleObject colling = MetaAccessorUtil.findGetterMeta(bean.getClass(), field, ReflectionAccess.PRIVATE);
        Assertion.notNull(colling, "passing argument with unbounded key " + field + " of bean : " + bean);
        return PropertyAccessorUtil.getProperty(bean, colling, level);
    }

    public static <T> T getProperty(Object bean, AccessibleObject colling, ReflectionAccess level) {
        Assertion.notNull(colling, "this field is required; it must not be null");
        try {
            if (colling instanceof Method) {
                return PropertyAccessorUtil.getProperty(bean, (Method)colling, level);
            }
            if (colling instanceof Field) {
                return PropertyAccessorUtil.getProperty(bean, (Field)colling, level);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static <T> T getProperty(Object bean, Method colling, ReflectionAccess access) {
        Assertion.notNull(colling, "this field is required; it must not be null");
        Assertion.isTrue(!access.isAccess(colling.getModifiers()), "Trying to illegal access " + colling.getName());
        try {
            colling.setAccessible(true);
            return (T)colling.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public static <T> T getProperty(Object bean, Field colling, ReflectionAccess access) {
        Assertion.notNull(colling, "this field is required; it must not be null");
        Assertion.isTrue(!access.isAccess(colling.getModifiers()), "Trying to illegal access " + colling.getName());
        try {
            colling.setAccessible(true);
            return (T)colling.get(bean);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    public static <T> T getProperty(Object bean, Field colling) {
        Assertion.notNull(colling, "this field is required; it must not be null");
        try {
            colling.setAccessible(true);
            return (T)colling.get(bean);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    public static Boolean isProperty(Object bean, String field, ReflectionAccess level) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        try {
            return CastingUtil.boolValue((String)PropertyAccessorUtil.getProperty(bean, field, level));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static Field getType(Object bean, String field, ReflectionAccess level) {
        return FieldUtil.getField(bean.getClass(), field, level);
    }

    public static Map<String, Object> getProperties(Object bean) {
        return PropertyAccessorUtil.getProperties(bean, ReflectionAccess.PUBLIC);
    }

    public static Map<String, Object> getProperties(Object bean, ReflectionAccess level) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String _key : MetaAccessorUtil.getNamePropertiesMeta(bean.getClass(), level)) {
            properties.put(_key, PropertyAccessorUtil.getProperty(bean, _key, level));
        }
        return properties;
    }

    public static Map<String, Object> setProperties(Object bean, Map<String, Object> _map) {
        return PropertyAccessorUtil.setProperties(bean, _map, ReflectionAccess.PUBLIC);
    }

    public static Map<String, Object> setProperties(Object bean, Map<String, Object> _map, ReflectionAccess level) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String _key : _map.keySet()) {
            properties.put(_key, PropertyAccessorUtil.setProperty(bean, _key, level, _map.get(_key)));
        }
        return properties;
    }

    public static void setSafeProperty(Object bean, String field, Object value) {
        AccessibleObject colling = MetaAccessorUtil.setPropertyMeta(bean.getClass(), field, ReflectionAccess.PRIVATE, value);
        if (colling != null) {
            PropertyAccessorUtil.setSafeProperty(bean, colling, value);
        }
    }

    public static void setSafeProperty(Object bean, AccessibleObject colling, Object value) {
        if (colling != null) {
            PropertyAccessorUtil.setProperty(bean, colling, ReflectionAccess.PRIVATE, value);
        }
    }
}

