/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.factories;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.brijframework.util.factories.FileResourceUtils;

public class ClassFileResourceUtil
extends FileResourceUtils {
    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static List<File> getClassFiles() {
        return ClassFileResourceUtil.getFiles(System.getProperty("java.class.path")).stream().filter(file -> file.getPath().endsWith(".class")).collect(Collectors.toList());
    }

    public static List<String> getClassNames() {
        ArrayList<String> classes = new ArrayList<String>();
        for (File file : ClassFileResourceUtil.getClassFiles()) {
            String classPath = file.getPath().split("classes")[1];
            classes.add(ClassFileResourceUtil.getClassPaths(classPath));
        }
        return classes;
    }

    public static List<Class<?>> getClassList() {
        ArrayList classes = new ArrayList();
        for (String className : ClassFileResourceUtil.getClassNames()) {
            ClassFileResourceUtil.getSafeClass(className, ClassFileResourceUtil.getContextClassLoader()).ifPresent(cls -> classes.add((Class<?>)cls));
        }
        return classes;
    }

    public static Optional<Class<?>> getSafeClass(String className, ClassLoader classLoader) {
        try {
            return Optional.ofNullable(Class.forName(className, false, classLoader));
        }
        catch (Throwable e) {
            return Optional.ofNullable(null);
        }
    }

    public static String getClassPaths(String classPath) {
        return classPath.replaceFirst("[/\\\\]", "").replace(".class", "").replaceAll("[/\\\\]", ".");
    }

    public static void main(String[] args) throws Exception {
        ClassFileResourceUtil.getClassList().forEach(System.out::println);
    }
}

