/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.factories;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.brijframework.util.factories.FileResourceUtils;

public class JarFileResourceUtil
extends FileResourceUtils {
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String CLASS_EXT = ".class";

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static List<String> getJarContent(String jarPath) throws IOException {
        ArrayList<String> content = new ArrayList<String>();
        JarFile jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            content.add(entry.getName());
        }
        return content;
    }

    public static List<String> getJarClassNames(String jarPath) throws IOException {
        return JarFileResourceUtil.getJarContent(jarPath).stream().filter(file -> file.endsWith(CLASS_EXT)).map(file -> JarFileResourceUtil.getClassPaths(file)).collect(Collectors.toList());
    }

    public static String getClassPaths(String classPath) {
        return classPath.replace(CLASS_EXT, "").replaceAll("[/\\\\]", ".");
    }

    public static List<Class<?>> getClassList() {
        ArrayList classes = new ArrayList();
        for (String className : JarFileResourceUtil.getClassNames()) {
            JarFileResourceUtil.getSafeClass(className, JarFileResourceUtil.getContextClassLoader()).ifPresent(cls -> classes.add((Class<?>)cls));
        }
        return classes;
    }

    private static List<String> getClassNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : JarFileResourceUtil.getJarFiles()) {
            try {
                list.addAll(JarFileResourceUtil.getJarClassNames(file.getPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static Optional<Class<?>> getSafeClass(String className, ClassLoader classLoader) {
        try {
            return Optional.ofNullable(Class.forName(className, false, classLoader));
        }
        catch (Throwable e) {
            return Optional.ofNullable(null);
        }
    }

    public static List<File> getJarFiles() {
        return JarFileResourceUtil.getFiles(System.getProperty(JAVA_CLASS_PATH)).stream().filter(file -> file.getPath().endsWith(".jar")).collect(Collectors.toList());
    }

    public static void main(String[] args) throws Exception {
        JarFileResourceUtil.getClassList().forEach(System.out::println);
    }
}

