/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.printer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import org.brijframework.util.casting.DateUtil;
import org.brijframework.util.reflect.InstanceUtil;

public class GraphParser {
    private StreamTokenizer tokenizer;
    private File sourceFile;
    private FileReader fileReader;
    private char commentChar = (char)35;
    static GraphParser parser;
    Object object;

    public static GraphParser getParser(String path) {
        parser = (GraphParser)InstanceUtil.getSingletonInstance(GraphParser.class, new File(path));
        GraphParser.parser.sourceFile = new File(path);
        parser.init();
        return parser;
    }

    public static GraphParser getParser(File path) {
        parser = (GraphParser)InstanceUtil.getSingletonInstance(GraphParser.class, path);
        GraphParser.parser.sourceFile = path;
        parser.init();
        return parser;
    }

    private void init() {
        this.isTokenizable(this.sourceFile);
    }

    public GraphParser(File sourceFile) {
        this.isTokenizable(sourceFile);
    }

    public GraphParser(File sourceFile, char commentChar) {
        this.commentChar = commentChar;
        this.isTokenizable(sourceFile);
    }

    public GraphParser(String aString) {
        if (!this.isTokenizable(new File(aString))) {
            this.tokenizer = new StreamTokenizer(new StringReader(aString));
        }
    }

    public GraphParser(String aString, char commentChar) {
        this.commentChar = commentChar;
        if (!this.isTokenizable(new File(aString))) {
            this.tokenizer = new StreamTokenizer(new StringReader(aString));
        }
    }

    public GraphParser(StringBuffer strBuf) {
        this.tokenizer = new StreamTokenizer(new StringReader(strBuf.toString()));
    }

    public GraphParser(StringBuffer strBuf, char commentChar) {
        this.commentChar = commentChar;
        this.tokenizer = new StreamTokenizer(new StringReader(strBuf.toString()));
    }

    public Hashtable<?, ?> getHashtable() {
        this.streamTokenInitializer();
        Object val = this.makeObjectCumExceptionCatcher();
        if (val instanceof Hashtable) {
            return (Hashtable)val;
        }
        throw new RuntimeException("Invalid file");
    }

    public Collection<?> getCollection() {
        this.streamTokenInitializer();
        Object val = this.makeObjectCumExceptionCatcher();
        if (val instanceof Collection) {
            return (Collection)val;
        }
        throw new RuntimeException("Invalid file");
    }

    private Object makeObjectCumExceptionCatcher() {
        try {
            Object obje = this.makeObject();
            if (this.fileReader != null) {
                this.fileReader.close();
            }
            this.sourceFile = null;
            return obje;
        }
        catch (IOException exc) {
            exc.printStackTrace();
            throw new RuntimeException("Unexpected IOException thrown");
        }
    }

    private Object makeObject() throws IOException {
        int c = this.tokenizer.nextToken();
        switch (c) {
            case -3: 
            case 34: 
            case 39: {
                System.out.println("tokenizer.sval=" + this.tokenizer.sval);
                return "";
            }
            case -2: {
                double d = this.tokenizer.nval;
                if (Math.floor(d) == d) {
                    return new Integer((int)d);
                }
                return new Double(d);
            }
            case 123: {
                this.tokenizer.pushBack();
                return this.makeDictionary();
            }
            case 91: {
                this.tokenizer.pushBack();
                return this.makeCollection();
            }
        }
        throw this.saParserException(this.tokenizer.lineno(), ' ');
    }

    private Hashtable<?, ?> makeDictionary() throws IOException {
        Hashtable<Object, Object> hash = new Hashtable<Object, Object>();
        int c = this.tokenizer.nextToken();
        if (c != 123) {
            throw this.saParserException(this.tokenizer.lineno(), '{');
        }
        while (!this.endOfElement('}')) {
            Object key = this.makeObject();
            if (this.tokenizer.nextToken() != 61) {
                throw this.saParserException(this.tokenizer.lineno(), '=');
            }
            Object value = this.makeObject();
            if (this.tokenizer.nextToken() != 59) {
                throw this.saParserException(this.tokenizer.lineno(), ';');
            }
            if (value.getClass().equals(String.class) && ((String)value).toLowerCase().equals("no")) {
                value = Boolean.FALSE;
            }
            if (value.getClass().equals(String.class) && ((String)value).toLowerCase().equals("yes")) {
                value = Boolean.TRUE;
            }
            hash.put(key, value);
        }
        return hash;
    }

    public Object getObject() {
        return this.object;
    }

    private Collection<?> makeCollection() throws IOException {
        ArrayList<Object> vector = new ArrayList<Object>();
        int c = this.tokenizer.nextToken();
        if (c != 91) {
            throw this.saParserException(this.tokenizer.lineno(), ']');
        }
        while (!this.endOfElement(']')) {
            Object element = this.makeObject();
            vector.add(element);
            if (this.endOfElement(']')) break;
            if (this.tokenizer.nextToken() == 44) continue;
            throw this.saParserException(this.tokenizer.lineno(), ',');
        }
        return vector;
    }

    private void streamTokenInitializer() {
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.wordChars(33, 255);
        this.tokenizer.commentChar(this.commentChar);
        this.tokenizer.quoteChar(39);
        this.tokenizer.quoteChar(34);
        this.tokenizer.ordinaryChar(61);
        this.tokenizer.ordinaryChar(44);
        this.tokenizer.ordinaryChar(59);
        this.tokenizer.ordinaryChar(123);
        this.tokenizer.ordinaryChar(125);
        this.tokenizer.ordinaryChar(40);
        this.tokenizer.ordinaryChar(41);
        this.tokenizer.ordinaryChar(91);
        this.tokenizer.ordinaryChar(93);
        this.tokenizer.ordinaryChar(60);
        this.tokenizer.ordinaryChar(62);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.parseNumbers();
    }

    private boolean endOfElement(char endChar) throws IOException {
        if (this.tokenizer.nextToken() == endChar) {
            return true;
        }
        this.tokenizer.pushBack();
        return false;
    }

    private Date makeDate(String date) {
        return DateUtil.dateObject(date);
    }

    private Date makeDateTime(String date) {
        return DateUtil.sqlDateTimeObject(date);
    }

    private boolean isTokenizable(File sourceFile) {
        try {
            if (sourceFile.isFile()) {
                this.fileReader = new FileReader(sourceFile);
                this.tokenizer = new StreamTokenizer(this.fileReader);
                this.sourceFile = sourceFile;
                return true;
            }
            return false;
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("File not found" + sourceFile);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Have Security Exception");
        }
    }

    public void setCommentChar(char commentChar) {
        this.commentChar = commentChar;
    }

    private RuntimeException saParserException(int lineNo, char expectedToken) {
        if (this.sourceFile != null) {
            String fileName = this.sourceFile.getName();
            return new RuntimeException("File " + fileName + " CANNOT be parsed. Unexpected token at line :" + lineNo + " expecting " + expectedToken);
        }
        return new RuntimeException("Unexpected token at line number: " + lineNo + " expecting " + expectedToken);
    }
}

