/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.ClassUtil;
import org.brijframework.util.reflect.ParamUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.text.StringUtil;

public abstract class MethodUtil {
    private static boolean isValidParam(Method _method, Class<?> ... _classes) {
        Assertion.notNull(_method, "this method name is required; it must not be null");
        if (_classes == null && _method.getParameterTypes().length == 0) {
            return true;
        }
        if (_classes.length == 0 && _method.getParameterTypes().length == 0) {
            return true;
        }
        return ParamUtil.isValidParam(_method, (Object[])_classes);
    }

    public static List<Method> fillMethods(Method[] methods, ReflectionAccess _accessLevel, Class<?> ... _classes) {
        Assertion.notNull(methods, "this arg is required; it must not be null methods");
        LinkedList<Method> returnList = new LinkedList<Method>();
        for (Method method : methods) {
            if (!_accessLevel.isAccess(method.getModifiers()) || !MethodUtil.isValidParam(method, _classes)) continue;
            returnList.add(method);
        }
        return returnList;
    }

    private static Collection<Method> fillMethods(Method[] methods, ReflectionAccess _accessLevel) {
        Assertion.notNull(methods, "this arg is required; it must not be null methods");
        LinkedList<Method> returnList = new LinkedList<Method>();
        for (Method method : methods) {
            if (!_accessLevel.isAccess(method.getModifiers())) continue;
            returnList.add(method);
        }
        return returnList;
    }

    private static Collection<Method> fillMethods(Method[] methods, Class<?> ... _classes) {
        Assertion.notNull(methods, "this arg is required; it must not be null methods");
        LinkedList<Method> returnList = new LinkedList<Method>();
        for (Method method : methods) {
            if (!MethodUtil.isValidParam(method, _classes)) continue;
            returnList.add(method);
        }
        return returnList;
    }

    private static Collection<Method> findMethod(Method[] methods, String _method, ReflectionAccess _accessLevel) {
        Assertion.notNull(methods, "this arg is required; it must not be null methods");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        LinkedList<Method> returnList = new LinkedList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(_method) || !_accessLevel.isAccess(method.getModifiers())) continue;
            returnList.add(method);
        }
        return returnList;
    }

    private static List<Method> findMethod(Method[] methods, ReflectionAccess _accessLevel, String _method, Class<?> ... _classes) {
        Assertion.notNull(methods, "this arg is required; it must not be null methods");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        LinkedList<Method> returnList = new LinkedList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(_method) || !_accessLevel.isAccess(method.getModifiers()) || !MethodUtil.isValidParam(method, _classes)) continue;
            returnList.add(method);
        }
        return returnList;
    }

    private static Method findMethod(Method[] methods, String _method, ReflectionAccess _accessLevel, Class<?> ... _classes) {
        Assertion.notNull(methods, "this arg is required; it must not be null methods");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        for (Method method : methods) {
            if (!method.getName().equals(_method) || !_accessLevel.isAccess(method.getModifiers()) || !MethodUtil.isValidParam(method, _classes)) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Class<?> _class, String _method, Class<?> ... _classes) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        try {
            return _class.getMethod(_method, _classes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    public static Collection<Method> getAllMethod(Class<?> _class, Class<?> ... _params) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        try {
            return MethodUtil.fillMethods(_class.getMethods(), _params);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static Method getMethod(Class<?> _class, String _method, Object ... _param) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        return MethodUtil.getMethod(_class, _method, ReflectionAccess.PUBLIC, _param);
    }

    public static Method getMethod(Class<?> _class, String _method, ReflectionAccess _accessLevel, Class<?> ... _classes) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        Method returnMethod = MethodUtil.findMethod(_class.getDeclaredMethods(), _method, _accessLevel, _classes);
        if (returnMethod != null) {
            return returnMethod;
        }
        if (_class.getSuperclass() != null) {
            for (Class<?> supClass : ClassUtil.getAllSuperClass(_class)) {
                returnMethod = MethodUtil.findMethod(supClass.getDeclaredMethods(), _method, _accessLevel, _classes);
                if (returnMethod == null) continue;
                return returnMethod;
            }
        }
        return null;
    }

    public static Method getMethod(Class<?> _class, String _method, ReflectionAccess _accessLevel, Object ... _param) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        return MethodUtil.getMethod(_class, _method, _accessLevel, ParamUtil.paramClasses(_param));
    }

    public static Collection<Method> getAllMethod(Class<?> _class) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        return MethodUtil.getAllMethod(_class, ReflectionAccess.PUBLIC);
    }

    public static Collection<Method> getAllMethod(Class<?> _class, ReflectionAccess _accessLevel) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        LinkedList<Method> returnMethods = new LinkedList<Method>();
        returnMethods.addAll(MethodUtil.fillMethods(_class.getDeclaredMethods(), _accessLevel));
        if (_class.getSuperclass() != null) {
            for (Class<?> supClass : ClassUtil.getAllSuperClass(_class)) {
                returnMethods.addAll(MethodUtil.fillMethods(supClass.getDeclaredMethods(), _accessLevel));
            }
        }
        return returnMethods;
    }

    public static List<Method> getAllOverloadMethod(Class<?> _class, String _method, ReflectionAccess _accessLevel) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        LinkedList<Method> returnMethods = new LinkedList<Method>();
        returnMethods.addAll(MethodUtil.findMethod(_class.getDeclaredMethods(), _method, _accessLevel));
        if (_class.getSuperclass() != null) {
            for (Class<?> _super : ClassUtil.getAllSuperClass(_class)) {
                returnMethods.addAll(MethodUtil.findMethod(_super.getDeclaredMethods(), _method, _accessLevel));
            }
        }
        return returnMethods;
    }

    public static Method getMethod(Class<?> _class, String _method, int params, ReflectionAccess _accessLevel) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        for (Method method : MethodUtil.getAllOverloadMethod(_class, _method, _accessLevel)) {
            if (method.getParameterCount() != params) continue;
            return method;
        }
        return null;
    }

    public static List<Method> getAllOverrideMethod(Class<?> _class, String _method, ReflectionAccess _accessLevel, Object ... _param) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        Assertion.notNull(_method, "this method name is required; it must not be null");
        LinkedList<Method> returnMethods = new LinkedList<Method>();
        returnMethods.addAll(MethodUtil.findMethod(_class.getDeclaredMethods(), _accessLevel, _method, ParamUtil.paramClasses(_param)));
        for (Class<?> _super : ClassUtil.getAllSuperClass(_class)) {
            returnMethods.addAll(MethodUtil.findMethod(_super.getDeclaredMethods(), _accessLevel, _method, ParamUtil.paramClasses(_param)));
        }
        return returnMethods;
    }

    public static Boolean hasSetter(Class<?> _class) {
        Method[] methods;
        Assertion.notNull(_class, "this class name is required; it must not be null");
        for (Method method : methods = _class.getMethods()) {
            if (!MethodUtil.isSetter(method)) continue;
            System.out.println("setter: " + method);
        }
        return false;
    }

    public static Boolean hasGetter(Class<?> _class) {
        Method[] methods;
        Assertion.notNull(_class, "this class name is required; it must not be null");
        for (Method method : methods = _class.getMethods()) {
            if (!MethodUtil.isGetter(method)) continue;
            System.out.println("getter: " + method);
        }
        return false;
    }

    public static String getFieldName(Method _method) {
        if (MethodUtil.isGetter(_method)) {
            return StringUtil.lowerFirst(StringUtil.getOfter(_method.getName(), "get"));
        }
        if (MethodUtil.isSetter(_method)) {
            return StringUtil.lowerFirst(StringUtil.getOfter(_method.getName(), "set"));
        }
        return _method.getName();
    }

    public static boolean isGetter(Method _method) {
        Assertion.notNull(_method, "this method is required; it must not be null");
        if (!_method.getName().startsWith("get")) {
            return false;
        }
        if (_method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(_method.getReturnType());
    }

    public static boolean isSetter(Method _method) {
        Assertion.notNull(_method, "this method is required; it must not be null");
        if (!_method.getName().startsWith("set")) {
            return false;
        }
        return _method.getParameterTypes().length == 1;
    }

    public static Boolean isMethodExists(Object _object, String _methodName) {
        Assertion.notNull(_object, "this object is required; it must not be null");
        Assertion.notNull(_methodName, "this method name is required; it must not be null");
        Collection<Method> methods = MethodUtil.getAllMethod(_object.getClass());
        for (Method method : methods) {
            if (!method.getName().equals(_methodName)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchInterface(Class<?> cls, Class<?> cld) {
        Assertion.notNull(cls, "this class is required; it must not be null left");
        Assertion.notNull(cld, "this class is required; it must not be null right");
        for (Class<?> C : cld.getInterfaces()) {
            if (C != cls) continue;
            return true;
        }
        return false;
    }

    public static boolean matchSuperClass(Class<?> cls, Class<?> cld) {
        Assertion.notNull(cls, "this class is required; it must not be null left");
        Assertion.notNull(cld, "this class is required; it must not be null right");
        for (Class<?> C : ClassUtil.getAllSuperClass(cld)) {
            if (C == cls) {
                return true;
            }
            if (!MethodUtil.matchInterface(cls, C)) continue;
            return true;
        }
        return false;
    }

    public static Method findMethod(Class<?> _class, String _method, ReflectionAccess _accessLevel, Class<?> ... paramClasses) {
        List<Method> methods = MethodUtil.getAllOverloadMethod(_class, _method, _accessLevel);
        if (methods.size() > 0) {
            return methods.get(0);
        }
        return null;
    }
}

