/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.info;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.github.hyperliquid.sdk.api.API;
import io.github.hyperliquid.sdk.model.info.Candle;
import io.github.hyperliquid.sdk.model.info.ClearinghouseState;
import io.github.hyperliquid.sdk.model.info.Fill;
import io.github.hyperliquid.sdk.model.info.FrontendOpenOrder;
import io.github.hyperliquid.sdk.model.info.OpenOrder;
import io.github.hyperliquid.sdk.model.info.PerpDexStatus;
import io.github.hyperliquid.sdk.model.info.SpotClearinghouseState;
import io.github.hyperliquid.sdk.parser.CandleParser;
import io.github.hyperliquid.sdk.utils.Error;
import io.github.hyperliquid.sdk.websocket.WebsocketManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Info
extends API {
    private final ObjectMapper mapper = new ObjectMapper();
    private final boolean skipWs;
    private WebsocketManager wsManager;
    private final Map<String, Integer> nameToCoin = new HashMap<String, Integer>();
    private final Map<Integer, Integer> coinToAsset = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> assetToSzDecimals = new HashMap<Integer, Integer>();

    public Info(String baseUrl, int timeout, boolean skipWs) {
        super(baseUrl, timeout);
        this.skipWs = skipWs;
        if (!skipWs) {
            this.wsManager = new WebsocketManager(baseUrl, this.mapper);
        }
        try {
            int szDec;
            JsonNode a;
            JsonNode meta;
            int assetId;
            JsonNode spot = this.spotMeta();
            if (spot != null && spot.has("universe") && spot.get("universe").isArray()) {
                JsonNode universe = spot.get("universe");
                for (int i = 0; i < universe.size(); ++i) {
                    JsonNode asset = universe.get(i);
                    String name = asset.has("name") ? asset.get("name").asText() : "SPOT_" + i;
                    int index = asset.has("index") ? asset.get("index").asInt() : i;
                    assetId = index + 10000;
                    if (asset.has("coin")) {
                        this.nameToCoin.putIfAbsent(name, asset.get("coin").asInt());
                    } else {
                        this.nameToCoin.putIfAbsent(name, index);
                    }
                    this.coinToAsset.putIfAbsent(index, assetId);
                    if (!spot.has("tokens") || !asset.has("tokens") || !asset.get("tokens").isArray() || asset.get("tokens").size() < 1) continue;
                    int baseTokenIndex = asset.get("tokens").get(0).asInt();
                    JsonNode tokens = spot.get("tokens");
                    if (!tokens.isArray() || baseTokenIndex < 0 || baseTokenIndex >= tokens.size()) continue;
                    JsonNode baseInfo = tokens.get(baseTokenIndex);
                    int szDec2 = baseInfo.has("szDecimals") ? baseInfo.get("szDecimals").asInt() : 2;
                    this.assetToSzDecimals.putIfAbsent(assetId, szDec2);
                }
            }
            if ((meta = this.meta()) != null && meta.has("universe") && meta.get("universe").isArray()) {
                JsonNode universe = meta.get("universe");
                for (int i = 0; i < universe.size(); ++i) {
                    a = universe.get(i);
                    String nm = a.has("name") ? a.get("name").asText() : "ASSET_" + i;
                    assetId = i;
                    this.nameToCoin.putIfAbsent(nm, i);
                    this.coinToAsset.putIfAbsent(i, assetId);
                    szDec = a.has("szDecimals") ? a.get("szDecimals").asInt() : 2;
                    this.assetToSzDecimals.putIfAbsent(assetId, szDec);
                }
            }
            if (meta != null && meta.has("assets") && meta.get("assets").isArray()) {
                JsonNode assets = meta.get("assets");
                for (int i = 0; i < assets.size(); ++i) {
                    a = assets.get(i);
                    int assetId2 = a.has("id") ? a.get("id").asInt() : i;
                    int coinId = a.has("coin") ? a.get("coin").asInt() : i;
                    this.coinToAsset.putIfAbsent(coinId, assetId2);
                    szDec = a.has("szDecimals") ? a.get("szDecimals").asInt() : 2;
                    this.assetToSzDecimals.putIfAbsent(assetId2, szDec);
                }
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public JsonNode allMids() {
        Map<String, String> payload = Map.of("type", "allMids");
        return this.post("/info", payload);
    }

    public Map<String, String> allMidsTyped() {
        JsonNode node = this.allMids();
        return (Map)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, String.class));
    }

    public JsonNode allMids(String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "allMids");
        if (dex != null) {
            payload.put("dex", dex);
        }
        return this.post("/info", payload);
    }

    public Map<String, String> allMidsTyped(String dex) {
        JsonNode node = this.allMids(dex);
        return (Map)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, String.class));
    }

    public JsonNode meta() {
        Map<String, String> payload = Map.of("type", "meta");
        return this.post("/info", payload);
    }

    public JsonNode meta(String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "meta");
        if (dex != null) {
            payload.put("dex", dex);
        }
        return this.post("/info", payload);
    }

    public JsonNode metaAndAssetCtxs() {
        Map<String, String> payload = Map.of("type", "metaAndAssetCtxs");
        return this.post("/info", payload);
    }

    public JsonNode spotMeta() {
        Map<String, String> payload = Map.of("type", "spotMeta");
        return this.post("/info", payload);
    }

    public JsonNode spotMetaAndAssetCtxs() {
        Map<String, String> payload = Map.of("type", "spotMetaAndAssetCtxs");
        return this.post("/info", payload);
    }

    public JsonNode l2Snapshot(int coin) {
        Map<String, Integer> payload = Map.of("type", "l2Snapshot", "coin", coin);
        return this.post("/info", payload);
    }

    public JsonNode candlesSnapshot(int coin, long intervalMs, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "candlesSnapshot");
        payload.put("coin", coin);
        payload.put("intervalMs", intervalMs);
        payload.put("startMs", startMs);
        payload.put("endMs", endMs);
        return this.post("/info", payload);
    }

    public JsonNode candleSnapshot(int coin, String interval, long startTime, long endTime) {
        String coinStr = this.coinIdToInfoCoinString(coin);
        LinkedHashMap<String, Object> req = new LinkedHashMap<String, Object>();
        req.put("coin", coinStr);
        req.put("interval", interval);
        req.put("startTime", startTime);
        req.put("endTime", endTime);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "candleSnapshot");
        payload.put("req", req);
        return this.post("/info", payload);
    }

    public List<Candle> candlesSnapshotTyped(int coin, long intervalMs, long startMs, long endMs) {
        JsonNode node = this.candlesSnapshot(coin, intervalMs, startMs, endMs);
        return CandleParser.parseList(node);
    }

    public List<Candle> candleSnapshotTyped(int coin, String interval, long startTime, long endTime) {
        JsonNode node = this.candleSnapshot(coin, interval, startTime, endTime);
        return CandleParser.parseList(node);
    }

    public List<Candle> candleSnapshotTyped(String coinName, String interval, long startTime, long endTime) {
        LinkedHashMap<String, Object> req = new LinkedHashMap<String, Object>();
        req.put("coin", coinName);
        req.put("interval", interval);
        req.put("startTime", startTime);
        req.put("endTime", endTime);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "candleSnapshot");
        payload.put("req", req);
        JsonNode node = this.post("/info", payload);
        return CandleParser.parseList(node);
    }

    private String coinIdToInfoCoinString(int coinId) {
        try {
            JsonNode m = this.meta();
            if (m != null && m.has("universe") && m.get("universe").isArray()) {
                String nm;
                JsonNode a;
                JsonNode uni = m.get("universe");
                if (coinId >= 0 && coinId < uni.size() && (a = uni.get(coinId)) != null && a.has("name") && (nm = a.get("name").asText()) != null && !nm.isEmpty()) {
                    return nm;
                }
            }
        }
        catch (Error error) {
            // empty catch block
        }
        return "@" + coinId;
    }

    public Optional<Candle> candleSnapshotLatestTyped(int coin, String interval) {
        long endTime = System.currentTimeMillis();
        long intervalMs = this.intervalToMs(interval);
        long startTime = endTime - intervalMs;
        JsonNode node = this.candleSnapshot(coin, interval, startTime, endTime);
        return CandleParser.parseLatest(node);
    }

    private long intervalToMs(String interval) {
        if (interval == null) {
            throw new Error("\u95f4\u9694\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (interval) {
            case "1m": {
                return 60000L;
            }
            case "3m": {
                return 180000L;
            }
            case "5m": {
                return 300000L;
            }
            case "15m": {
                return 900000L;
            }
            case "30m": {
                return 1800000L;
            }
            case "1h": {
                return 3600000L;
            }
            case "2h": {
                return 0x6DDD00L;
            }
            case "4h": {
                return 14400000L;
            }
            case "8h": {
                return 28800000L;
            }
            case "12h": {
                return 43200000L;
            }
            case "1d": {
                return 86400000L;
            }
            case "3d": {
                return 259200000L;
            }
            case "1w": {
                return 604800000L;
            }
            case "1M": {
                return 2592000000L;
            }
        }
        throw new Error("\u4e0d\u652f\u6301\u7684\u95f4\u9694\u5b57\u7b26\u4e32\uff1a" + interval);
    }

    public JsonNode userState(String address) {
        Map<String, String> payload = Map.of("type", "userState", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode openOrders(String address) {
        Map<String, String> payload = Map.of("type", "openOrders", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode openOrders(String address, String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "openOrders");
        payload.put("user", address);
        if (dex != null) {
            payload.put("dex", dex);
        }
        return this.post("/info", payload);
    }

    public List<OpenOrder> openOrdersTyped(String address) {
        JsonNode node = this.openOrders(address);
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, OpenOrder.class));
    }

    public List<OpenOrder> openOrdersTyped(String address, String dex) {
        JsonNode node = this.openOrders(address, dex);
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, OpenOrder.class));
    }

    public JsonNode userFillsByTime(String address, long startTime, long endTime) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFillsByTime");
        payload.put("user", address);
        payload.put("startTime", startTime);
        payload.put("endTime", endTime);
        return this.post("/info", payload);
    }

    public JsonNode userFillsByTime(String address, long startTime, long endTime, boolean aggregateByTime) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFillsByTime");
        payload.put("user", address);
        payload.put("startTime", startTime);
        payload.put("endTime", endTime);
        payload.put("aggregateByTime", aggregateByTime);
        return this.post("/info", payload);
    }

    public List<Fill> userFillsByTimeTyped(String address, long startTime, long endTime) {
        JsonNode node = this.userFillsByTime(address, startTime, endTime);
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Fill.class));
    }

    public List<Fill> userFillsByTimeTyped(String address, long startTime, long endTime, boolean aggregateByTime) {
        JsonNode node = this.userFillsByTime(address, startTime, endTime, aggregateByTime);
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Fill.class));
    }

    public JsonNode userFees(String address) {
        Map<String, String> payload = Map.of("type", "userFees", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode fundingHistory(int coin, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "fundingHistory");
        payload.put("coin", coin);
        payload.put("startMs", startMs);
        payload.put("endMs", endMs);
        return this.post("/info", payload);
    }

    public JsonNode userFundingHistory(String address, int coin, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFundingHistory");
        payload.put("user", address);
        payload.put("coin", coin);
        payload.put("startMs", startMs);
        payload.put("endMs", endMs);
        return this.post("/info", payload);
    }

    public JsonNode userNonFundingLedgerUpdates(String address, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userNonFundingLedgerUpdates");
        payload.put("user", address);
        payload.put("startMs", startMs);
        payload.put("endMs", endMs);
        return this.post("/info", payload);
    }

    public JsonNode historicalOrders(String address, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "historicalOrders");
        payload.put("user", address);
        payload.put("startMs", startMs);
        payload.put("endMs", endMs);
        return this.post("/info", payload);
    }

    public JsonNode userTwapSliceFills(String address, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userTwapSliceFills");
        payload.put("user", address);
        payload.put("startMs", startMs);
        payload.put("endMs", endMs);
        return this.post("/info", payload);
    }

    public JsonNode frontendOpenOrders(String address) {
        Map<String, String> payload = Map.of("type", "frontendOpenOrders", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode frontendOpenOrders(String address, String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "frontendOpenOrders");
        payload.put("user", address);
        if (dex != null) {
            payload.put("dex", dex);
        }
        return this.post("/info", payload);
    }

    public List<FrontendOpenOrder> frontendOpenOrdersTyped(String address) {
        JsonNode node = this.frontendOpenOrders(address);
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, FrontendOpenOrder.class));
    }

    public List<FrontendOpenOrder> frontendOpenOrdersTyped(String address, String dex) {
        JsonNode node = this.frontendOpenOrders(address, dex);
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, FrontendOpenOrder.class));
    }

    public JsonNode userFills(String address, boolean aggregateByTime) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFills");
        payload.put("user", address);
        payload.put("aggregateByTime", aggregateByTime);
        return this.post("/info", payload);
    }

    public List<Fill> userFillsTyped(String address, boolean aggregateByTime) {
        JsonNode node = this.userFills(address, aggregateByTime);
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Fill.class));
    }

    public JsonNode perpDexs() {
        Map<String, String> payload = Map.of("type", "perpDexs");
        return this.post("/info", payload);
    }

    public List<Map<String, Object>> perpDexsTyped() {
        JsonNode node = this.perpDexs();
        return (List)this.mapper.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class)));
    }

    public JsonNode clearinghouseState(String address, String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "clearinghouseState");
        payload.put("user", address);
        if (dex != null && !dex.isEmpty()) {
            payload.put("dex", dex);
        }
        return this.post("/info", payload);
    }

    public ClearinghouseState clearinghouseStateTyped(String address, String dex) {
        JsonNode node = this.clearinghouseState(address, dex);
        return (ClearinghouseState)this.mapper.convertValue((Object)node, ClearinghouseState.class);
    }

    public JsonNode spotClearinghouseState(String address) {
        Map<String, String> payload = Map.of("type", "spotClearinghouseState", "user", address);
        return this.post("/info", payload);
    }

    public SpotClearinghouseState spotClearinghouseStateTyped(String address) {
        JsonNode node = this.spotClearinghouseState(address);
        return (SpotClearinghouseState)this.mapper.convertValue((Object)node, SpotClearinghouseState.class);
    }

    public JsonNode spotDeployState(String address) {
        Map<String, String> payload = Map.of("type", "spotDeployState", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode portfolio(String address) {
        Map<String, String> payload = Map.of("type", "portfolio", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode userRole(String address) {
        Map<String, String> payload = Map.of("type", "userRole", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode userRateLimit(String address) {
        Map<String, String> payload = Map.of("type", "userRateLimit", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode queryReferralState(String address) {
        Map<String, String> payload = Map.of("type", "queryReferralState", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode querySubAccounts(String address) {
        Map<String, String> payload = Map.of("type", "querySubAccounts", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode queryUserToMultiSigSigners(String address) {
        Map<String, String> payload = Map.of("type", "queryUserToMultiSigSigners", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode queryPerpDeployAuctionStatus() {
        Map<String, String> payload = Map.of("type", "queryPerpDeployAuctionStatus");
        return this.post("/info", payload);
    }

    public JsonNode querySpotDeployAuctionStatus() {
        Map<String, String> payload = Map.of("type", "querySpotDeployAuctionStatus");
        return this.post("/info", payload);
    }

    public JsonNode perpDexStatus(String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "perpDexStatus");
        payload.put("dex", dex == null ? "" : dex);
        return this.post("/info", payload);
    }

    public PerpDexStatus perpDexStatusTyped(String dex) {
        JsonNode node = this.perpDexStatus(dex);
        return (PerpDexStatus)this.mapper.convertValue((Object)node, PerpDexStatus.class);
    }

    public JsonNode queryUserDexAbstractionState(String address) {
        Map<String, String> payload = Map.of("type", "queryUserDexAbstractionState", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode userVaultEquities(String address) {
        Map<String, String> payload = Map.of("type", "userVaultEquities", "user", address);
        return this.post("/info", payload);
    }

    public JsonNode extraAgents(String address) {
        Map<String, String> payload = Map.of("type", "extraAgents", "user", address);
        return this.post("/info", payload);
    }

    public int nameToAsset(String name) {
        JsonNode m2;
        int assetId;
        String nm;
        int i;
        JsonNode universe;
        Integer coin = this.nameToCoin.get(name);
        if (coin == null) {
            JsonNode m = this.meta();
            if (m != null && m.has("universe") && m.get("universe").isArray()) {
                universe = m.get("universe");
                for (i = 0; i < universe.size(); ++i) {
                    JsonNode a = universe.get(i);
                    nm = a.has("name") ? a.get("name").asText() : "ASSET_" + i;
                    assetId = i;
                    this.nameToCoin.putIfAbsent(nm, i);
                    this.coinToAsset.putIfAbsent(i, assetId);
                    int szDec = a.has("szDecimals") ? a.get("szDecimals").asInt() : 2;
                    this.assetToSzDecimals.putIfAbsent(assetId, szDec);
                }
            }
            coin = this.nameToCoin.get(name);
        }
        if (coin == null) {
            JsonNode spot = this.spotMeta();
            if (spot != null && spot.has("universe") && spot.get("universe").isArray()) {
                universe = spot.get("universe");
                for (i = 0; i < universe.size(); ++i) {
                    JsonNode asset = universe.get(i);
                    nm = asset.has("name") ? asset.get("name").asText() : "SPOT_" + i;
                    int index = asset.has("index") ? asset.get("index").asInt() : i;
                    int assetId2 = index + 10000;
                    this.nameToCoin.putIfAbsent(nm, index);
                    this.coinToAsset.putIfAbsent(index, assetId2);
                    if (!spot.has("tokens") || !asset.has("tokens") || !asset.get("tokens").isArray() || asset.get("tokens").size() < 1) continue;
                    int baseTokenIndex = asset.get("tokens").get(0).asInt();
                    JsonNode tokens = spot.get("tokens");
                    if (!tokens.isArray() || baseTokenIndex < 0 || baseTokenIndex >= tokens.size()) continue;
                    JsonNode baseInfo = tokens.get(baseTokenIndex);
                    int szDec = baseInfo.has("szDecimals") ? baseInfo.get("szDecimals").asInt() : 2;
                    this.assetToSzDecimals.putIfAbsent(assetId2, szDec);
                }
            }
            coin = this.nameToCoin.get(name);
        }
        if (coin == null) {
            throw new Error("Unknown coin name: " + name);
        }
        Integer asset = this.coinToAsset.get(coin);
        if (asset == null && (m2 = this.meta()) != null && m2.has("assets") && m2.get("assets").isArray()) {
            JsonNode assets = m2.get("assets");
            for (int i2 = 0; i2 < assets.size(); ++i2) {
                JsonNode a = assets.get(i2);
                assetId = a.has("id") ? a.get("id").asInt() : i2;
                int coinId = a.has("coin") ? a.get("coin").asInt() : i2;
                this.coinToAsset.putIfAbsent(coinId, assetId);
                int szDec = a.has("szDecimals") ? a.get("szDecimals").asInt() : 2;
                this.assetToSzDecimals.putIfAbsent(assetId, szDec);
            }
            asset = this.coinToAsset.get(coin);
        }
        if (asset == null) {
            throw new Error("Unknown asset for coin: " + name);
        }
        return asset;
    }

    public void subscribe(JsonNode subscription, WebsocketManager.MessageCallback callback) {
        if (this.skipWs) {
            throw new Error("WebSocket disabled by skipWs");
        }
        this.wsManager.subscribe(subscription, callback);
    }

    public void unsubscribe(JsonNode subscription) {
        if (this.skipWs) {
            return;
        }
        this.wsManager.unsubscribe(subscription);
    }

    public void closeWs() {
        if (this.wsManager != null) {
            this.wsManager.stop();
        }
    }

    public void addConnectionListener(WebsocketManager.ConnectionListener listener) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.addConnectionListener(listener);
        }
    }

    public void removeConnectionListener(WebsocketManager.ConnectionListener listener) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.removeConnectionListener(listener);
        }
    }

    public void setMaxReconnectAttempts(int max) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.setMaxReconnectAttempts(max);
        }
    }

    public void setNetworkCheckIntervalSeconds(int seconds) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.setNetworkCheckIntervalSeconds(seconds);
        }
    }

    public void setReconnectBackoffMs(long initialMs, long maxMs) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.setReconnectBackoffMs(initialMs, maxMs);
        }
    }
}

