/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.parser;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.hyperliquid.sdk.model.info.Candle;
import io.github.hyperliquid.sdk.utils.Error;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class CandleParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private CandleParser() {
    }

    public static List<Candle> parseList(JsonNode node) throws Error {
        if (node == null || !node.isArray()) {
            throw new Error("Candle \u5217\u8868\u89e3\u6790\u5931\u8d25\uff1a\u8fd4\u56de\u4e0d\u662f\u6570\u7ec4\u6216\u4e3a\u7a7a");
        }
        ArrayList<Candle> result = new ArrayList<Candle>();
        for (int i = 0; i < node.size(); ++i) {
            JsonNode e = node.get(i);
            if (e == null || e.isNull() || !e.isObject()) continue;
            try {
                Candle c = (Candle)MAPPER.treeToValue((TreeNode)e, Candle.class);
                result.add(c);
                continue;
            }
            catch (Exception ex) {
                throw new Error("Candle \u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff08\u7d22\u5f15=" + i + "): " + ex.getMessage());
            }
        }
        return result;
    }

    public static Optional<Candle> parseLatest(JsonNode node) throws Error {
        List<Candle> list = CandleParser.parseList(node);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(list.size() - 1));
    }
}

