/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.hyperliquid.sdk.model.order.OrderRequest;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.OrderWire;
import io.github.hyperliquid.sdk.utils.Error;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public final class Signing {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private Signing() {
    }

    public static String floatToWire(double value) {
        BigDecimal bd = BigDecimal.valueOf(value);
        String s = bd.stripTrailingZeros().toPlainString();
        if (s.equals("-0")) {
            s = "0";
        }
        return s;
    }

    public static long floatToIntForHashing(double value) {
        BigDecimal bd = BigDecimal.valueOf(value);
        BigDecimal scaled = bd.multiply(BigDecimal.valueOf(1000000000L));
        return scaled.longValue();
    }

    public static long floatToUsdInt(double value) {
        BigDecimal bd = BigDecimal.valueOf(value);
        BigDecimal scaled = bd.multiply(BigDecimal.valueOf(1000000L));
        return scaled.longValue();
    }

    public static long floatToInt(double value) {
        BigDecimal bd = BigDecimal.valueOf(value);
        BigDecimal scaled = bd.multiply(BigDecimal.valueOf(100000000L));
        return scaled.longValue();
    }

    public static long getTimestampMs() {
        return System.currentTimeMillis();
    }

    public static Object orderTypeToWire(OrderType orderType) {
        if (orderType == null) {
            return null;
        }
        LinkedHashMap out = new LinkedHashMap();
        orderType.getLimit().ifPresent(limit -> {
            LinkedHashMap<String, String> limitObj = new LinkedHashMap<String, String>();
            limitObj.put("tif", limit.getTif());
            out.put("limit", limitObj);
        });
        orderType.getTrigger().ifPresent(trigger -> {
            LinkedHashMap<String, Object> trigObj = new LinkedHashMap<String, Object>();
            trigObj.put("triggerPx", Signing.floatToWire(trigger.getTriggerPx()));
            trigObj.put("isMarket", trigger.isMarket());
            trigObj.put("tpsl", trigger.getTpsl());
            out.put("trigger", trigObj);
        });
        return out.isEmpty() ? null : out;
    }

    public static OrderWire orderRequestToOrderWire(int coinId, OrderRequest req) {
        String szStr = Signing.floatToWire(req.getSz());
        String pxStr = req.getLimitPx() == null ? null : Signing.floatToWire(req.getLimitPx());
        Object orderTypeWire = Signing.orderTypeToWire(req.getOrderType());
        return new OrderWire(coinId, req.isBuy(), szStr, pxStr, orderTypeWire, req.isReduceOnly(), req.getCloid());
    }

    public static byte[] actionHash(Object action, long nonce, String vaultAddress, Long expiresAfter) {
        try {
            MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
            byte[] actionBytes = MAPPER.writeValueAsBytes(action);
            packer.packBinaryHeader(actionBytes.length);
            packer.writePayload(actionBytes);
            packer.packLong(nonce);
            if (vaultAddress != null) {
                packer.packBoolean(true);
                byte[] addrBytes = Signing.addressToBytes(vaultAddress);
                packer.packBinaryHeader(addrBytes.length);
                packer.writePayload(addrBytes);
            } else {
                packer.packBoolean(false);
            }
            if (expiresAfter != null) {
                packer.packBoolean(true);
                packer.packLong(expiresAfter.longValue());
            } else {
                packer.packBoolean(false);
            }
            packer.close();
            byte[] full = packer.toByteArray();
            return Hash.sha3((byte[])full);
        }
        catch (Exception e) {
            throw new Error("Failed to compute action hash: " + e.getMessage());
        }
    }

    public static byte[] addressToBytes(String address) {
        String clean = Numeric.cleanHexPrefix((String)address);
        byte[] full = Numeric.hexStringToByteArray((String)clean);
        if (full.length == 20) {
            return full;
        }
        if (full.length > 20) {
            return Arrays.copyOfRange(full, full.length - 20, full.length);
        }
        byte[] out = new byte[20];
        System.arraycopy(full, 0, out, 20 - full.length, full.length);
        return out;
    }

    public static Map<String, String> signTypedData(Credentials credentials, Map<String, Object> domain, Map<String, Object> types, Map<String, Object> message) {
        try {
            byte[] payloadToSign = null;
            Object actionHashObj = message.get("actionHash");
            if (actionHashObj instanceof String) {
                try {
                    payloadToSign = Base64.getDecoder().decode((String)actionHashObj);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (payloadToSign == null) {
                LinkedHashMap<String, Object> typedData = new LinkedHashMap<String, Object>();
                typedData.put("types", types);
                typedData.put("primaryType", message.getOrDefault("primaryType", "Action"));
                typedData.put("domain", domain);
                LinkedHashMap<String, Object> msgCopy = new LinkedHashMap<String, Object>(message);
                msgCopy.remove("primaryType");
                typedData.put("message", msgCopy);
                String json = MAPPER.writeValueAsString(typedData);
                payloadToSign = Hash.sha3((byte[])json.getBytes(StandardCharsets.UTF_8));
            }
            Sign.SignatureData sig = Sign.signMessage((byte[])payloadToSign, (ECKeyPair)credentials.getEcKeyPair(), (boolean)false);
            String r = Numeric.toHexString((byte[])sig.getR());
            String s = Numeric.toHexString((byte[])sig.getS());
            String v = Numeric.toHexString((byte[])sig.getV());
            LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
            out.put("r", r);
            out.put("s", s);
            out.put("v", v);
            return out;
        }
        catch (Exception e) {
            throw new Error("Failed to sign typed data: " + e.getMessage());
        }
    }

    public static Map<String, Object> orderWiresToOrderAction(List<OrderWire> orders) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "order");
        ArrayList wires = new ArrayList();
        for (OrderWire o : orders) {
            LinkedHashMap<String, Object> w = new LinkedHashMap<String, Object>();
            w.put("coin", o.coin);
            w.put("isBuy", o.isBuy);
            w.put("sz", o.sz);
            if (o.limitPx != null) {
                w.put("limitPx", o.limitPx);
            }
            if (o.orderType != null) {
                w.put("orderType", o.orderType);
            }
            w.put("reduceOnly", o.reduceOnly);
            if (o.cloid != null) {
                w.put("cloid", o.cloid.getRaw());
            }
            wires.add(w);
        }
        action.put("orders", wires);
        return action;
    }
}

