/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.apis;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.hyperliquid.sdk.apis.Info;
import io.github.hyperliquid.sdk.model.approve.ApproveAgentResult;
import io.github.hyperliquid.sdk.model.info.ClearinghouseState;
import io.github.hyperliquid.sdk.model.info.UpdateLeverage;
import io.github.hyperliquid.sdk.model.order.Cloid;
import io.github.hyperliquid.sdk.model.order.InstrumentType;
import io.github.hyperliquid.sdk.model.order.LimitOrderType;
import io.github.hyperliquid.sdk.model.order.ModifyRequest;
import io.github.hyperliquid.sdk.model.order.Order;
import io.github.hyperliquid.sdk.model.order.OrderGroup;
import io.github.hyperliquid.sdk.model.order.OrderRequest;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.OrderWire;
import io.github.hyperliquid.sdk.model.order.Tif;
import io.github.hyperliquid.sdk.model.order.TriggerOrderType;
import io.github.hyperliquid.sdk.model.wallet.ApiWallet;
import io.github.hyperliquid.sdk.utils.HypeError;
import io.github.hyperliquid.sdk.utils.HypeHttpClient;
import io.github.hyperliquid.sdk.utils.JSONUtil;
import io.github.hyperliquid.sdk.utils.Signing;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.web3j.crypto.Credentials;
import org.web3j.utils.Numeric;

public class Exchange {
    private final ApiWallet apiWallet;
    private final HypeHttpClient hypeHttpClient;
    private final Info info;
    private String vaultAddress;
    private final Map<String, Double> defaultSlippageByCoin = new ConcurrentHashMap<String, Double>();
    private Double defaultSlippage = 0.05;

    public String getVaultAddress() {
        return this.vaultAddress;
    }

    public void setVaultAddress(String vaultAddress) {
        this.vaultAddress = vaultAddress;
    }

    public Exchange(HypeHttpClient hypeHttpClient, ApiWallet wallet, Info info) {
        this.hypeHttpClient = hypeHttpClient;
        this.apiWallet = wallet;
        this.info = info;
    }

    public JsonNode scheduleCancel(Long timeMs) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "scheduleCancel");
        if (timeMs != null) {
            action.put("time", timeMs);
        }
        return this.postAction(action);
    }

    public UpdateLeverage updateLeverage(String coinName, final boolean crossed, final int leverage) {
        final int assetId = this.ensureAssetId(coinName);
        LinkedHashMap<String, Object> actions = new LinkedHashMap<String, Object>(){
            {
                this.put("type", "updateLeverage");
                this.put("asset", assetId);
                this.put("isCross", crossed);
                this.put("leverage", leverage);
            }
        };
        return JSONUtil.convertValue((Object)this.postAction((Map<String, Object>)actions), UpdateLeverage.class);
    }

    public Order order(OrderRequest req, Map<String, Object> builder) {
        OrderRequest effective = this.prepareRequest(req);
        this.formatOrderSize(effective);
        this.marketOpenTransition(effective);
        this.formatOrderPrice(effective);
        int assetId = this.ensureAssetId(effective.getCoin());
        OrderWire wire = Signing.orderRequestToOrderWire(assetId, effective);
        Map<String, Object> action = this.buildOrderAction(List.of(wire), builder);
        Long expiresAfter = effective.getExpiresAfter() != null ? effective.getExpiresAfter() : 120000L;
        JsonNode node = this.postAction(action, expiresAfter);
        return JSONUtil.convertValue((Object)node, Order.class);
    }

    public Order order(OrderRequest req) {
        return this.order(req, null);
    }

    private void formatOrderSize(OrderRequest req) {
        if (req == null || req.getSz() == null) {
            return;
        }
        Integer szDecimals = this.info.getSzDecimals(req.getCoin());
        if (szDecimals == null) {
            return;
        }
        BigDecimal bd = BigDecimal.valueOf(req.getSz()).setScale((int)szDecimals, RoundingMode.DOWN);
        req.setSz(bd.doubleValue());
    }

    private void formatOrderPrice(OrderRequest req) {
        if (req == null) {
            return;
        }
        Integer szDecimals = this.info.getSzDecimals(req.getCoin());
        if (szDecimals == null) {
            return;
        }
        boolean isSpot = req.getInstrumentType() == InstrumentType.SPOT;
        int decimals = (isSpot ? 8 : 6) - szDecimals;
        if (decimals < 0) {
            decimals = 0;
        }
        if (req.getLimitPx() != null) {
            BigDecimal bd = BigDecimal.valueOf(req.getLimitPx()).round(new MathContext(5, RoundingMode.HALF_UP)).setScale(decimals, RoundingMode.HALF_UP);
            req.setLimitPx(bd.doubleValue());
        }
        if (req.getOrderType() != null && req.getOrderType().getTrigger() != null) {
            double triggerPx = req.getOrderType().getTrigger().getTriggerPx();
            BigDecimal bd = BigDecimal.valueOf(triggerPx).round(new MathContext(5, RoundingMode.HALF_UP)).setScale(decimals, RoundingMode.HALF_UP);
            double newPx = bd.doubleValue();
            TriggerOrderType oldTrig = req.getOrderType().getTrigger();
            TriggerOrderType newTrig = new TriggerOrderType(newPx, oldTrig.isMarket(), oldTrig.getTpslEnum());
            LimitOrderType oldLimit = req.getOrderType().getLimit();
            req.setOrderType(new OrderType(oldLimit, newTrig));
        }
    }

    private OrderRequest prepareRequest(OrderRequest req) {
        if (this.isClosePositionMarket(req)) {
            if (req.getIsBuy() != null && req.getSz() != null) {
                return req;
            }
            double szi = this.inferSignedPosition(req.getCoin());
            if (szi == 0.0) {
                throw new HypeError("No position to close for coin " + req.getCoin());
            }
            boolean isBuy = szi < 0.0;
            double sz = req.getSz() != null && req.getSz() > 0.0 ? req.getSz() : Math.abs(szi);
            return OrderRequest.Close.market(req.getCoin(), isBuy, sz, req.getCloid());
        }
        return req;
    }

    private boolean isClosePositionMarket(OrderRequest req) {
        return req != null && req.getInstrumentType() == InstrumentType.PERP && req.getOrderType() != null && req.getOrderType().getLimit() != null && req.getOrderType().getLimit().getTif() == Tif.IOC && Boolean.TRUE.equals(req.getReduceOnly()) && req.getLimitPx() == null;
    }

    private double inferSignedPosition(String coin) {
        ClearinghouseState state = this.info.userState(this.apiWallet.getPrimaryWalletAddress().toLowerCase());
        if (state == null || state.getAssetPositions() == null) {
            return 0.0;
        }
        for (ClearinghouseState.AssetPositions ap : state.getAssetPositions()) {
            ClearinghouseState.Position pos = ap.getPosition();
            if (pos == null || !coin.equalsIgnoreCase(pos.getCoin())) continue;
            try {
                return Double.parseDouble(pos.getSzi());
            }
            catch (Exception ignored) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public JsonNode updateIsolatedMargin(double amount, String coinName) {
        int assetId = this.ensureAssetId(coinName);
        long ntli = Signing.floatToUsdInt(amount);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "updateIsolatedMargin");
        action.put("asset", assetId);
        action.put("isBuy", true);
        action.put("ntli", ntli);
        return this.postAction(action);
    }

    public JsonNode bulkOrders(List<OrderRequest> requests, Map<String, Object> builder, String grouping) {
        requests.forEach(this::formatOrderSize);
        requests.forEach(this::marketOpenTransition);
        requests.forEach(this::formatOrderPrice);
        ArrayList<OrderWire> wires = new ArrayList<OrderWire>();
        for (OrderRequest r : requests) {
            int assetId = this.ensureAssetId(r.getCoin());
            wires.add(Signing.orderRequestToOrderWire(assetId, r));
        }
        Map<String, Object> action = this.buildOrderAction(wires, builder);
        if (grouping != null && !grouping.isEmpty()) {
            action.put("grouping", grouping);
        }
        return this.postAction(action);
    }

    public JsonNode bulkOrders(OrderGroup orderGroup) {
        return this.bulkOrders(orderGroup.getOrders(), null, orderGroup.getGroupingType().getValue());
    }

    public JsonNode bulkOrders(OrderGroup orderGroup, Map<String, Object> builder) {
        return this.bulkOrders(orderGroup.getOrders(), builder, orderGroup.getGroupingType().getValue());
    }

    public JsonNode bulkOrders(List<OrderRequest> requests) {
        return this.bulkOrders(requests, null, null);
    }

    public JsonNode cancel(String coinName, long oid) {
        int assetId = this.ensureAssetId(coinName);
        LinkedHashMap<String, Number> cancel = new LinkedHashMap<String, Number>();
        cancel.put("a", assetId);
        cancel.put("o", oid);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "cancel");
        action.put("cancels", List.of(cancel));
        return this.postAction(action);
    }

    public JsonNode cancelByCloid(String coinName, Cloid cloid) {
        int assetId = this.ensureAssetId(coinName);
        LinkedHashMap<String, Object> cancel = new LinkedHashMap<String, Object>();
        cancel.put("asset", assetId);
        cancel.put("cloid", cloid == null ? null : cloid.getRaw());
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "cancelByCloid");
        action.put("cancels", List.of(cancel));
        return this.postAction(action);
    }

    public JsonNode modifyOrder(String coinName, long oid, OrderRequest newReq) {
        int assetId = this.ensureAssetId(coinName);
        OrderWire wire = Signing.orderRequestToOrderWire(assetId, newReq);
        LinkedHashMap<String, Object> modify = new LinkedHashMap<String, Object>();
        modify.put("oid", oid);
        modify.put("order", wire);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "batchModify");
        action.put("modifies", List.of(modify));
        return this.postAction(action);
    }

    public JsonNode modifyOrder(String coinName, Cloid cloid, OrderRequest newReq) {
        int assetId = this.ensureAssetId(coinName);
        OrderWire wire = Signing.orderRequestToOrderWire(assetId, newReq);
        LinkedHashMap<String, Object> modify = new LinkedHashMap<String, Object>();
        modify.put("oid", cloid == null ? null : cloid.getRaw());
        modify.put("order", wire);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "batchModify");
        action.put("modifies", List.of(modify));
        return this.postAction(action);
    }

    public JsonNode bulkModifyOrders(List<ModifyRequest> modifyRequests) {
        if (modifyRequests == null || modifyRequests.isEmpty()) {
            throw new HypeError("Modify requests cannot be empty");
        }
        ArrayList modifies = new ArrayList();
        for (ModifyRequest mr : modifyRequests) {
            int assetId = this.ensureAssetId(mr.getCoinName());
            OrderWire wire = Signing.orderRequestToOrderWire(assetId, mr.getNewOrder());
            LinkedHashMap<String, Object> modify = new LinkedHashMap<String, Object>();
            if (mr.getOid() != null) {
                modify.put("oid", mr.getOid());
            } else if (mr.getCloid() != null) {
                modify.put("oid", mr.getCloid().getRaw());
            } else {
                throw new HypeError("Either oid or cloid must be provided for modify request");
            }
            modify.put("order", wire);
            modifies.add(modify);
        }
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "batchModify");
        action.put("modifies", modifies);
        return this.postAction(action);
    }

    private Map<String, Object> buildOrderAction(List<OrderWire> wires, Map<String, Object> builder) {
        Map<String, Object> action = Signing.orderWiresToOrderAction(wires);
        if (builder != null && !builder.isEmpty()) {
            Object bVal;
            LinkedHashMap<String, Object> filtered = new LinkedHashMap<String, Object>();
            if (builder.containsKey("b") && (bVal = builder.get("b")) instanceof String) {
                String s = (String)bVal;
                filtered.put("b", s.toLowerCase());
            }
            if (builder.containsKey("f")) {
                Object fVal = builder.get("f");
                if (!(fVal instanceof Number)) {
                    throw new HypeError("builder.f \u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570\uff08\u6570\u503c\u7c7b\u578b\uff09");
                }
                long f = ((Number)fVal).longValue();
                if (f < 0L) {
                    throw new HypeError("builder.f \u4e0d\u80fd\u4e3a\u8d1f\u6570");
                }
                if (f > 1000000L) {
                    throw new HypeError("builder.f \u8fc7\u5927\uff0c\u8bf7\u786e\u8ba4\u5355\u4f4d\u4e0e\u53d6\u503c\u8303\u56f4");
                }
                filtered.put("f", f);
            }
            if (!filtered.isEmpty()) {
                action.put("builder", filtered);
            }
        }
        return action;
    }

    public JsonNode agentEnableDexAbstraction() {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "agentEnableDexAbstraction");
        return this.postAction(action);
    }

    public JsonNode userDexAbstraction(String user, boolean enabled) {
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "userDexAbstraction");
        action.put("user", user == null ? null : user.toLowerCase());
        action.put("enabled", enabled);
        action.put("nonce", nonce);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "user", "type", "address"), Map.of("name", "enabled", "type", "bool"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:UserDexAbstraction", this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }

    public JsonNode createSubAccount(String name) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "createSubAccount");
        action.put("name", name);
        return this.postAction(action);
    }

    public JsonNode subAccountTransfer(String subAccountUser, boolean isDeposit, long usd) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "subAccountTransfer");
        action.put("subAccountUser", subAccountUser == null ? null : subAccountUser.toLowerCase());
        action.put("isDeposit", isDeposit);
        action.put("usd", usd);
        return this.postAction(action);
    }

    public JsonNode usdTransfer(double amount, String destination) {
        long time = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "usdSend");
        action.put("destination", destination);
        action.put("amount", String.valueOf(amount));
        action.put("time", time);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "destination", "type", "string"), Map.of("name", "amount", "type", "string"), Map.of("name", "time", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:UsdSend", this.isMainnet());
        return this.postActionWithSignature(action, signature, time);
    }

    public JsonNode spotTransfer(double amount, String destination, String token) {
        long time = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "spotSend");
        action.put("destination", destination);
        action.put("token", token);
        action.put("amount", String.valueOf(amount));
        action.put("time", time);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "destination", "type", "string"), Map.of("name", "token", "type", "string"), Map.of("name", "amount", "type", "string"), Map.of("name", "time", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:SpotSend", this.isMainnet());
        return this.postActionWithSignature(action, signature, time);
    }

    public JsonNode withdrawFromBridge(double amount, String destination) {
        long time = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "withdraw3");
        action.put("destination", destination);
        action.put("amount", String.valueOf(amount));
        action.put("time", time);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "destination", "type", "string"), Map.of("name", "amount", "type", "string"), Map.of("name", "time", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:Withdraw", this.isMainnet());
        return this.postActionWithSignature(action, signature, time);
    }

    public JsonNode usdClassTransfer(boolean toPerp, double amount) {
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "usdClassTransfer");
        Object strAmount = String.valueOf(amount);
        if (this.vaultAddress != null && !this.vaultAddress.isEmpty()) {
            strAmount = (String)strAmount + " subaccount:" + this.vaultAddress;
        }
        action.put("amount", strAmount);
        action.put("toPerp", toPerp);
        action.put("nonce", nonce);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "amount", "type", "string"), Map.of("name", "toPerp", "type", "bool"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:UsdClassTransfer", this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }

    public JsonNode sendAsset(String destination, String sourceDex, String destinationDex, String token, String amount, String fromSubAccount) {
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "sendAsset");
        action.put("destination", destination);
        action.put("sourceDex", sourceDex);
        action.put("destinationDex", destinationDex);
        action.put("token", token);
        action.put("amount", amount);
        String from = fromSubAccount != null ? fromSubAccount : (this.vaultAddress != null ? this.vaultAddress : "");
        action.put("fromSubAccount", from);
        action.put("nonce", nonce);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "destination", "type", "string"), Map.of("name", "sourceDex", "type", "string"), Map.of("name", "destinationDex", "type", "string"), Map.of("name", "token", "type", "string"), Map.of("name", "amount", "type", "string"), Map.of("name", "fromSubAccount", "type", "string"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:SendAsset", this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }

    public JsonNode approveBuilderFee(String builder, String maxFeeRate) {
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "approveBuilderFee");
        action.put("builder", builder == null ? null : builder.toLowerCase());
        action.put("maxFeeRate", maxFeeRate);
        action.put("nonce", nonce);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "maxFeeRate", "type", "string"), Map.of("name", "builder", "type", "address"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:ApproveBuilderFee", this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }

    public JsonNode setReferrer(String code) {
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "setReferrer");
        action.put("code", code);
        action.put("nonce", nonce);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "code", "type", "string"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:SetReferrer", this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }

    public JsonNode tokenDelegate(String validator, long wei, boolean isUndelegate) {
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "tokenDelegate");
        action.put("validator", validator == null ? null : validator.toLowerCase());
        action.put("wei", wei);
        action.put("isUndelegate", isUndelegate);
        action.put("nonce", nonce);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "validator", "type", "address"), Map.of("name", "wei", "type", "uint64"), Map.of("name", "isUndelegate", "type", "bool"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:TokenDelegate", this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }

    public JsonNode convertToMultiSigUser(String signersJson) {
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "convertToMultiSigUser");
        action.put("signers", signersJson);
        action.put("nonce", nonce);
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "signers", "type", "string"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:ConvertToMultiSigUser", this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }

    public JsonNode vaultTransfer(String vaultAddress, boolean isDeposit, long usd) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "vaultTransfer");
        action.put("vaultAddress", vaultAddress == null ? null : vaultAddress.toLowerCase());
        action.put("isDeposit", isDeposit);
        action.put("usd", usd);
        return this.postAction(action);
    }

    public JsonNode spotDeployRegisterToken(String tokenName, int szDecimals, int weiDecimals, int maxGas, String fullName) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> spec = new LinkedHashMap<String, Object>();
        spec.put("name", tokenName);
        spec.put("szDecimals", szDecimals);
        spec.put("weiDecimals", weiDecimals);
        LinkedHashMap<String, Object> registerToken2 = new LinkedHashMap<String, Object>();
        registerToken2.put("spec", spec);
        registerToken2.put("maxGas", maxGas);
        registerToken2.put("fullName", fullName);
        action.put("type", "spotDeploy");
        action.put("registerToken2", registerToken2);
        return this.postAction(action);
    }

    public JsonNode spotDeployUserGenesis(int token, List<String[]> userAndWei, List<Object[]> existingTokenAndWei) {
        ArrayList userAndWeiWire = new ArrayList();
        if (userAndWei != null) {
            for (String[] pair : userAndWei) {
                String user = pair[0] == null ? null : pair[0].toLowerCase();
                String wei = pair[1];
                ArrayList<String> entry = new ArrayList<String>();
                entry.add(user);
                entry.add(wei);
                userAndWeiWire.add(entry);
            }
        }
        ArrayList existingWire = new ArrayList();
        if (existingTokenAndWei != null) {
            for (Object[] pair : existingTokenAndWei) {
                Integer t = (Integer)pair[0];
                String wei = (String)pair[1];
                ArrayList<Object> entry = new ArrayList<Object>();
                entry.add(t);
                entry.add(wei);
                existingWire.add(entry);
            }
        }
        LinkedHashMap<String, Serializable> userGenesis = new LinkedHashMap<String, Serializable>();
        userGenesis.put("token", Integer.valueOf(token));
        userGenesis.put("userAndWei", userAndWeiWire);
        userGenesis.put("existingTokenAndWei", existingWire);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "spotDeploy");
        action.put("userGenesis", userGenesis);
        return this.postAction(action);
    }

    public JsonNode spotDeployEnableFreezePrivilege(int token) {
        return this.spotDeployTokenActionInner("enableFreezePrivilege", token);
    }

    public JsonNode spotDeployRevokeFreezePrivilege(int token) {
        return this.spotDeployTokenActionInner("revokeFreezePrivilege", token);
    }

    public JsonNode spotDeployFreezeUser(int token, String user, boolean freeze) {
        LinkedHashMap<String, Object> freezeUser = new LinkedHashMap<String, Object>();
        freezeUser.put("token", token);
        freezeUser.put("user", user == null ? null : user.toLowerCase());
        freezeUser.put("freeze", freeze);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "spotDeploy");
        action.put("freezeUser", freezeUser);
        return this.postAction(action);
    }

    public JsonNode spotDeployEnableQuoteToken(int token) {
        return this.spotDeployTokenActionInner("enableQuoteToken", token);
    }

    private JsonNode spotDeployTokenActionInner(String variant, int token) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Integer> variantObj = new LinkedHashMap<String, Integer>();
        variantObj.put("token", token);
        action.put("type", "spotDeploy");
        action.put(variant, variantObj);
        return this.postAction(action);
    }

    public JsonNode spotDeployGenesis(int token, String maxSupply, boolean noHyperliquidity) {
        LinkedHashMap<String, Object> genesis = new LinkedHashMap<String, Object>();
        genesis.put("token", token);
        genesis.put("maxSupply", maxSupply);
        if (noHyperliquidity) {
            genesis.put("noHyperliquidity", true);
        }
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "spotDeploy");
        action.put("genesis", genesis);
        return this.postAction(action);
    }

    public JsonNode spotDeployRegisterSpot(int baseToken, int quoteToken) {
        LinkedHashMap register = new LinkedHashMap();
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        tokens.add(baseToken);
        tokens.add(quoteToken);
        register.put("tokens", tokens);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "spotDeploy");
        action.put("registerSpot", register);
        return this.postAction(action);
    }

    public JsonNode spotDeployRegisterHyperliquidity(int spot, double startPx, double orderSz, int nOrders, Integer nSeededLevels) {
        LinkedHashMap<String, Object> register = new LinkedHashMap<String, Object>();
        register.put("spot", spot);
        register.put("startPx", String.valueOf(startPx));
        register.put("orderSz", String.valueOf(orderSz));
        register.put("nOrders", nOrders);
        if (nSeededLevels != null) {
            register.put("nSeededLevels", nSeededLevels);
        }
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "spotDeploy");
        action.put("registerHyperliquidity", register);
        return this.postAction(action);
    }

    public JsonNode spotDeploySetDeployerTradingFeeShare(int token, String share) {
        LinkedHashMap<String, Object> setShare = new LinkedHashMap<String, Object>();
        setShare.put("token", token);
        setShare.put("share", share);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "spotDeploy");
        action.put("setDeployerTradingFeeShare", setShare);
        return this.postAction(action);
    }

    public ApproveAgentResult approveAgent(String name) {
        byte[] bytes = new byte[32];
        new SecureRandom().nextBytes(bytes);
        String agentPrivateKey = "0x" + Numeric.toHexStringNoPrefix((byte[])bytes);
        Credentials agentCred = Credentials.create((String)agentPrivateKey);
        String agentAddress = agentCred.getAddress();
        long nonce = Signing.getTimestampMs();
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "approveAgent");
        action.put("agentAddress", agentAddress);
        action.put("nonce", nonce);
        if (name != null) {
            action.put("agentName", name);
        }
        List<Map<String, Object>> payloadTypes = List.of(Map.of("name", "hyperliquidChain", "type", "string"), Map.of("name", "agentAddress", "type", "address"), Map.of("name", "agentName", "type", "string"), Map.of("name", "nonce", "type", "uint64"));
        Map<String, Object> signature = Signing.signUserSignedAction(this.apiWallet.getCredentials(), action, payloadTypes, "HyperliquidTransaction:ApproveAgent", this.isMainnet());
        JsonNode resp = this.postActionWithSignature(action, signature, nonce);
        return new ApproveAgentResult(resp, agentPrivateKey, agentAddress);
    }

    public JsonNode postAction(Map<String, Object> action) {
        return this.postAction(action, null);
    }

    public JsonNode postAction(Map<String, Object> action, Long expiresAfter) {
        long ea;
        String signerAddr;
        String effectiveVault;
        long nonce = Signing.getTimestampMs();
        String type = String.valueOf(action.getOrDefault("type", ""));
        String string = effectiveVault = "usdClassTransfer".equals(type) || "sendAsset".equals(type) ? null : this.vaultAddress;
        if (effectiveVault != null && (effectiveVault = effectiveVault.toLowerCase()).equals(signerAddr = this.apiWallet.getPrimaryWalletAddress().toLowerCase())) {
            effectiveVault = null;
        }
        if (expiresAfter == null) {
            expiresAfter = 120000L;
        }
        if ((ea = expiresAfter.longValue()) < 1000000000000L) {
            ea = nonce + ea;
        }
        Map<String, Object> signature = Signing.signL1Action(this.apiWallet.getCredentials(), action, effectiveVault, nonce, ea, this.isMainnet());
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("action", action);
        payload.put("nonce", nonce);
        payload.put("signature", signature);
        if (effectiveVault != null) {
            payload.put("vaultAddress", effectiveVault);
        }
        payload.put("expiresAfter", ea);
        return this.hypeHttpClient.post("/exchange", payload);
    }

    private JsonNode postActionWithSignature(Map<String, Object> action, Map<String, Object> signature, long nonce) {
        String type = String.valueOf(action.getOrDefault("type", ""));
        boolean userSigned = "approveAgent".equals(type) || "userDexAbstraction".equals(type) || "usdSend".equals(type) || "withdraw3".equals(type) || "spotSend".equals(type) || "usdClassTransfer".equals(type) || "sendAsset".equals(type) || "approveBuilderFee".equals(type) || "setReferrer".equals(type) || "tokenDelegate".equals(type) || "convertToMultiSigUser".equals(type);
        String effectiveVault = "usdClassTransfer".equals(type) || "sendAsset".equals(type) ? null : this.vaultAddress;
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("action", action);
        payload.put("nonce", nonce);
        payload.put("signature", signature);
        if (!userSigned) {
            payload.put("vaultAddress", effectiveVault);
        } else {
            payload.put("vaultAddress", effectiveVault);
        }
        return this.hypeHttpClient.post("/exchange", payload);
    }

    private int ensureAssetId(String coinName) {
        Integer assetId = this.info.nameToAsset(coinName);
        if (assetId == null) {
            throw new HypeError("Unknown coin name: " + coinName);
        }
        return assetId;
    }

    private boolean isDexEnabled(JsonNode node) {
        if (node == null) {
            return false;
        }
        if (node.has("enabled")) {
            return node.get("enabled").asBoolean(false);
        }
        if (node.has("data") && node.get("data").has("enabled")) {
            return node.get("data").get("enabled").asBoolean(false);
        }
        String s = node.toString().toLowerCase();
        return s.contains("\"enabled\":true");
    }

    private boolean isOk(JsonNode node) {
        return node != null && node.has("status") && "ok".equalsIgnoreCase(node.get("status").asText());
    }

    private boolean isAlreadySet(JsonNode node) {
        return node != null && node.has("status") && "err".equalsIgnoreCase(node.get("status").asText()) && node.has("response") && node.get("response").isTextual() && node.get("response").asText().toLowerCase().contains("already set");
    }

    private void marketOpenTransition(OrderRequest req) {
        if (req == null) {
            return;
        }
        if (req.getLimitPx() == null && req.getOrderType() != null && req.getOrderType().getLimit() != null && req.getOrderType().getLimit().getTif() == Tif.IOC) {
            double slip = req.getSlippage() != null ? req.getSlippage() : this.defaultSlippageByCoin.getOrDefault(req.getCoin(), this.defaultSlippage);
            double slipPx = this.computeSlippagePrice(req.getCoin(), Boolean.TRUE.equals(req.getIsBuy()), slip);
            req.setLimitPx(slipPx);
        }
    }

    public double computeSlippagePrice(String coin, boolean isBuy, double slippage) {
        Map<String, String> mids = this.info.allMids();
        String midStr = mids.get(coin);
        if (midStr == null) {
            throw new HypeError("Failed to get mid price for coin " + coin + " (allMids returned empty or does not contain the coin)");
        }
        double basePx = Double.parseDouble(midStr);
        return basePx * (isBuy ? 1.0 + slippage : 1.0 - slippage);
    }

    public void setDefaultSlippage(double slippage) {
        this.defaultSlippage = slippage;
    }

    public void setDefaultSlippage(String coin, double slippage) {
        if (coin != null) {
            this.defaultSlippageByCoin.put(coin, slippage);
        }
    }

    public Order closePositionMarket(String coin) {
        return this.order(OrderRequest.Close.positionAtMarketAll(coin));
    }

    @Deprecated
    public Order closePositionAtMarketAll(String coin) {
        return this.closePositionMarket(coin);
    }

    public Order closePositionMarket(String coin, Double sz, Double slippage, Cloid cloid) {
        double szi = this.inferSignedPosition(coin);
        if (szi == 0.0) {
            throw new HypeError("No position to close for coin " + coin);
        }
        boolean isBuy = szi < 0.0;
        double closeSz = sz != null && sz > 0.0 ? sz : Math.abs(szi);
        OrderRequest req = OrderRequest.Close.market(coin, isBuy, closeSz, cloid);
        if (slippage != null) {
            req.setSlippage(slippage);
        }
        return this.order(req);
    }

    public Order closePositionMarket(String coin, Double sz, Double slippage, Cloid cloid, Map<String, Object> builder) {
        double szi = this.inferSignedPosition(coin);
        if (szi == 0.0) {
            throw new HypeError("No position to close for coin " + coin);
        }
        boolean isBuy = szi < 0.0;
        double closeSz = sz != null && sz > 0.0 ? sz : Math.abs(szi);
        OrderRequest req = OrderRequest.Close.market(coin, isBuy, closeSz, cloid);
        if (slippage != null) {
            req.setSlippage(slippage);
        }
        return this.order(req, builder);
    }

    @Deprecated
    public Order marketClose(String coin, Double sz, Double slippage, Cloid cloid) {
        return this.closePositionMarket(coin, sz, slippage, cloid);
    }

    @Deprecated
    public Order marketClose(String coin, Double sz, Double slippage, Cloid cloid, Map<String, Object> builder) {
        return this.closePositionMarket(coin, sz, slippage, cloid, builder);
    }

    public Order closePositionLimit(Tif tif, String coin, double limitPx, Cloid cloid) {
        double szi = this.inferSignedPosition(coin);
        if (szi == 0.0) {
            throw new HypeError("No position to close for coin " + coin);
        }
        boolean isBuy = szi < 0.0;
        double absSz = Math.abs(szi);
        OrderRequest req = OrderRequest.Close.limit(tif, coin, szi, limitPx, cloid);
        req.setSz(absSz);
        req.setIsBuy(isBuy);
        return this.order(req);
    }

    @Deprecated
    public Order closePositionLimitAll(Tif tif, String coin, double limitPx, Cloid cloid) {
        return this.closePositionLimit(tif, coin, limitPx, cloid);
    }

    public JsonNode closeAllPositions() {
        ClearinghouseState state = this.info.userState(this.apiWallet.getPrimaryWalletAddress().toLowerCase());
        if (state == null || state.getAssetPositions() == null || state.getAssetPositions().isEmpty()) {
            throw new HypeError("No positions to close");
        }
        ArrayList<OrderRequest> closeOrders = new ArrayList<OrderRequest>();
        for (ClearinghouseState.AssetPositions ap : state.getAssetPositions()) {
            double szi;
            ClearinghouseState.Position pos = ap.getPosition();
            if (pos == null || pos.getCoin() == null || pos.getSzi() == null) continue;
            try {
                szi = Double.parseDouble(pos.getSzi());
            }
            catch (Exception e) {
                continue;
            }
            if (szi == 0.0) continue;
            boolean isBuy = szi < 0.0;
            double closeSz = Math.abs(szi);
            OrderRequest req = OrderRequest.Close.market(pos.getCoin(), isBuy, closeSz, null);
            closeOrders.add(req);
        }
        if (closeOrders.isEmpty()) {
            throw new HypeError("No positions to close (all positions are zero)");
        }
        return this.bulkOrders(closeOrders);
    }

    @Deprecated
    public JsonNode closePositionAll() {
        return this.closeAllPositions();
    }

    private boolean isMainnet() {
        return "https://api.hyperliquid.xyz".equals(this.hypeHttpClient.getBaseUrl());
    }

    public JsonNode subAccountSpotTransfer(String subAccountUser, boolean isDeposit, String token, double amount) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "subAccountSpotTransfer");
        action.put("subAccountUser", subAccountUser);
        action.put("isDeposit", isDeposit);
        action.put("token", token);
        action.put("amount", String.valueOf(amount));
        return this.postAction(action);
    }

    public JsonNode multiSig(String multiSigUser, Map<String, Object> innerAction, List<Map<String, Object>> signatures, long nonce, String vaultAddress) {
        LinkedHashMap<String, Object> multiSigAction = new LinkedHashMap<String, Object>();
        multiSigAction.put("type", "multiSig");
        multiSigAction.put("signatureChainId", "0x66eee");
        multiSigAction.put("signatures", signatures);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("multiSigUser", multiSigUser.toLowerCase());
        payload.put("outerSigner", this.apiWallet.getPrimaryWalletAddress().toLowerCase());
        payload.put("action", innerAction);
        multiSigAction.put("payload", payload);
        Map<String, Object> signature = Signing.signMultiSigAction(this.apiWallet.getCredentials(), multiSigAction, this.isMainnet(), vaultAddress, nonce, null);
        return this.postActionWithSignature(multiSigAction, signature, nonce);
    }

    public JsonNode multiSig(String multiSigUser, Map<String, Object> innerAction, List<Map<String, Object>> signatures, long nonce) {
        return this.multiSig(multiSigUser, innerAction, signatures, nonce, this.vaultAddress);
    }

    public JsonNode perpDeploySetOracle(String dex, Map<String, String> oraclePxs, List<Map<String, String>> allMarkPxs, Map<String, String> externalPerpPxs) {
        ArrayList<List<String>> oraclePxsWire = new ArrayList<List<String>>();
        if (oraclePxs != null) {
            ArrayList<Map.Entry<String, String>> sorted = new ArrayList<Map.Entry<String, String>>(oraclePxs.entrySet());
            sorted.sort(Map.Entry.comparingByKey());
            for (Map.Entry entry : sorted) {
                oraclePxsWire.add(Arrays.asList((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        ArrayList<Object> markPxsWire = new ArrayList<Object>();
        if (allMarkPxs != null) {
            for (Map<String, String> map : allMarkPxs) {
                ArrayList markWire = new ArrayList();
                ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(map.entrySet());
                arrayList.sort(Map.Entry.comparingByKey());
                for (Map.Entry entry : arrayList) {
                    markWire.add(Arrays.asList((String)entry.getKey(), (String)entry.getValue()));
                }
                markPxsWire.add(markWire);
            }
        }
        ArrayList<List<String>> externalPerpPxsWire = new ArrayList<List<String>>();
        if (externalPerpPxs != null) {
            ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(externalPerpPxs.entrySet());
            arrayList.sort(Map.Entry.comparingByKey());
            for (Map.Entry entry : arrayList) {
                externalPerpPxsWire.add(Arrays.asList((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("dex", dex);
        linkedHashMap.put("oraclePxs", oraclePxsWire);
        linkedHashMap.put("markPxs", markPxsWire);
        linkedHashMap.put("externalPerpPxs", externalPerpPxsWire);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "perpDeploy");
        action.put("setOracle", linkedHashMap);
        return this.postAction(action);
    }

    public JsonNode useBigBlocks(boolean enable) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "evmUserModify");
        action.put("usingBigBlocks", enable);
        return this.postAction(action);
    }

    public JsonNode cValidatorRegister(String nodeIp, String name, String description, boolean delegationsDisabled, int commissionBps, String signer, boolean unjailed, long initialWei) {
        LinkedHashMap<String, String> nodeIpMap = new LinkedHashMap<String, String>();
        nodeIpMap.put("Ip", nodeIp);
        LinkedHashMap<String, Object> profile = new LinkedHashMap<String, Object>();
        profile.put("node_ip", nodeIpMap);
        profile.put("name", name);
        profile.put("description", description);
        profile.put("delegations_disabled", delegationsDisabled);
        profile.put("commission_bps", commissionBps);
        profile.put("signer", signer);
        LinkedHashMap<String, Serializable> register = new LinkedHashMap<String, Serializable>();
        register.put("profile", profile);
        register.put("unjailed", Boolean.valueOf(unjailed));
        register.put("initial_wei", Long.valueOf(initialWei));
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "CValidatorAction");
        action.put("register", register);
        return this.postAction(action);
    }

    public JsonNode cValidatorChangeProfile(String nodeIp, String name, String description, boolean unjailed, Boolean disableDelegations, Integer commissionBps, String signer) {
        LinkedHashMap<String, Object> changeProfile = new LinkedHashMap<String, Object>();
        if (nodeIp != null) {
            LinkedHashMap<String, String> nodeIpMap = new LinkedHashMap<String, String>();
            nodeIpMap.put("Ip", nodeIp);
            changeProfile.put("node_ip", nodeIpMap);
        } else {
            changeProfile.put("node_ip", null);
        }
        changeProfile.put("name", name);
        changeProfile.put("description", description);
        changeProfile.put("unjailed", unjailed);
        changeProfile.put("disable_delegations", disableDelegations);
        changeProfile.put("commission_bps", commissionBps);
        changeProfile.put("signer", signer);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "CValidatorAction");
        action.put("changeProfile", changeProfile);
        return this.postAction(action);
    }

    public JsonNode cValidatorUnregister() {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "CValidatorAction");
        action.put("unregister", null);
        return this.postAction(action);
    }

    public JsonNode cSignerJailSelf() {
        return this.cSignerInner("jailSelf");
    }

    public JsonNode cSignerUnjailSelf() {
        return this.cSignerInner("unjailSelf");
    }

    private JsonNode cSignerInner(String variant) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "CSignerAction");
        action.put(variant, null);
        return this.postAction(action);
    }

    public JsonNode noop(long nonce) {
        String signerAddr;
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "noop");
        String effectiveVault = this.vaultAddress;
        if (effectiveVault != null && (effectiveVault = effectiveVault.toLowerCase()).equals(signerAddr = this.apiWallet.getPrimaryWalletAddress().toLowerCase())) {
            effectiveVault = null;
        }
        Map<String, Object> signature = Signing.signL1Action(this.apiWallet.getCredentials(), action, effectiveVault, nonce, null, this.isMainnet());
        return this.postActionWithSignature(action, signature, nonce);
    }
}

