/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.info;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Fill {
    private Long time;
    private Integer coin;
    private String coinName;
    private Boolean isBuy;
    private Double size;
    private Double price;
    private Map<String, Object> extensions = new HashMap<String, Object>();

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public Integer getCoin() {
        return this.coin;
    }

    public void setCoin(Integer coin) {
        this.coin = coin;
    }

    public String getCoinName() {
        return this.coinName;
    }

    public void setCoinName(String coinName) {
        this.coinName = coinName;
    }

    public Boolean getIsBuy() {
        return this.isBuy;
    }

    public void setIsBuy(Boolean isBuy) {
        this.isBuy = isBuy;
    }

    public Double getSize() {
        return this.size;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    @JsonAnySetter
    public void put(String key, Object value) {
        this.extensions.put(key, value);
    }

    @JsonSetter(value="coin")
    public void setCoinFlexible(Object value) {
        if (value == null) {
            this.coin = null;
            this.coinName = null;
            return;
        }
        if (value instanceof Number) {
            this.coin = ((Number)value).intValue();
            this.coinName = null;
        } else {
            this.coin = null;
            this.coinName = String.valueOf(value);
        }
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.extensions;
    }

    public static class Builder {
        private final Fill f = new Fill();

        public Builder time(Long t) {
            this.f.time = t;
            return this;
        }

        public Builder coin(Integer c) {
            this.f.coin = c;
            return this;
        }

        public Builder isBuy(Boolean b) {
            this.f.isBuy = b;
            return this;
        }

        public Builder size(Double s) {
            this.f.size = s;
            return this;
        }

        public Builder price(Double p) {
            this.f.price = p;
            return this;
        }

        public Builder putExtra(String k, Object v) {
            this.f.extensions.put(k, v);
            return this;
        }

        public Fill build() {
            return this.f;
        }
    }
}

