/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

import io.github.hyperliquid.sdk.model.order.Cloid;
import io.github.hyperliquid.sdk.model.order.InstrumentType;
import io.github.hyperliquid.sdk.model.order.LimitOrderType;
import io.github.hyperliquid.sdk.model.order.OrderRequest;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.Tif;
import io.github.hyperliquid.sdk.model.order.TriggerOrderType;

public class OrderBuilder {
    private InstrumentType instrumentType;
    private String coin;
    private Boolean isBuy;
    private Double sz;
    private Double limitPx;
    private OrderType orderType;
    private Boolean reduceOnly = false;
    private Cloid cloid;
    private Double slippage;
    private Double triggerPx;
    private Boolean isMarketTrigger;
    private TriggerOrderType.TpslType tpsl;
    private Long expiresAfter;

    public OrderBuilder expiresAfter(Long expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public OrderBuilder perp(String coin) {
        this.instrumentType = InstrumentType.PERP;
        this.coin = coin;
        return this;
    }

    public OrderBuilder spot(String coin) {
        this.instrumentType = InstrumentType.SPOT;
        this.coin = coin;
        return this;
    }

    public OrderBuilder buy(Double sz) {
        this.isBuy = true;
        this.sz = sz;
        return this;
    }

    public OrderBuilder sell(Double sz) {
        this.isBuy = false;
        this.sz = sz;
        return this;
    }

    public OrderBuilder limitPrice(Double limitPx) {
        this.limitPx = limitPx;
        return this;
    }

    public OrderBuilder market() {
        this.limitPx = null;
        this.orderType = new OrderType(new LimitOrderType(Tif.IOC));
        return this;
    }

    public OrderBuilder market(Double slippage) {
        this.limitPx = null;
        this.slippage = slippage;
        this.orderType = new OrderType(new LimitOrderType(Tif.IOC));
        return this;
    }

    public OrderBuilder stopAbove(Double triggerPx) {
        this.triggerPx = triggerPx;
        this.tpsl = TriggerOrderType.TpslType.TP;
        this.isMarketTrigger = false;
        return this;
    }

    public OrderBuilder stopBelow(Double triggerPx) {
        this.triggerPx = triggerPx;
        this.tpsl = TriggerOrderType.TpslType.SL;
        this.isMarketTrigger = false;
        return this;
    }

    public OrderBuilder marketTrigger() {
        this.isMarketTrigger = true;
        return this;
    }

    public OrderBuilder gtc() {
        if (this.orderType == null || this.orderType.getLimit() == null) {
            this.orderType = new OrderType(new LimitOrderType(Tif.GTC));
        }
        return this;
    }

    public OrderBuilder ioc() {
        if (this.orderType == null || this.orderType.getLimit() == null) {
            this.orderType = new OrderType(new LimitOrderType(Tif.IOC));
        }
        return this;
    }

    public OrderBuilder alo() {
        if (this.orderType == null || this.orderType.getLimit() == null) {
            this.orderType = new OrderType(new LimitOrderType(Tif.ALO));
        }
        return this;
    }

    public OrderBuilder reduceOnly() {
        this.reduceOnly = true;
        return this;
    }

    public OrderBuilder cloid(Cloid cloid) {
        this.cloid = cloid;
        return this;
    }

    public OrderBuilder autoCloid() {
        this.cloid = Cloid.auto();
        return this;
    }

    public OrderRequest build() {
        if (this.coin == null || this.coin.isEmpty()) {
            throw new IllegalStateException("coin is required");
        }
        if (this.isBuy == null) {
            throw new IllegalStateException("direction is required (call buy() or sell())");
        }
        if (this.sz == null || this.sz <= 0.0) {
            throw new IllegalStateException("size must be positive");
        }
        if (this.triggerPx != null) {
            if (this.tpsl == null) {
                throw new IllegalStateException("tpsl is required for trigger order (call stopAbove() or stopBelow())");
            }
            this.orderType = new OrderType(new TriggerOrderType(this.triggerPx, this.isMarketTrigger != null && this.isMarketTrigger != false, this.tpsl));
        } else if (this.orderType == null) {
            this.orderType = new OrderType(new LimitOrderType(Tif.GTC));
        }
        OrderRequest req = new OrderRequest(this.instrumentType != null ? this.instrumentType : InstrumentType.PERP, this.coin, this.isBuy, this.sz, this.limitPx, this.orderType, this.reduceOnly, this.cloid);
        if (this.slippage != null) {
            req.setSlippage(this.slippage);
        }
        if (this.expiresAfter != null) {
            req.setExpiresAfter(this.expiresAfter);
        }
        return req;
    }
}

